/* complex_math.h   include file for complex math calls
Ken Stephenson, 8/91 */

typedef struct {double re,im;}  complex;

typedef struct {complex a,b,c,d; int flip;} Mobius; 
	/* flip=0 ==> orientation preserving, else reversing */

extern double cAbs(/*complex*/);
extern double Arg(/*complex*/);
extern double inv_dist(/*complex,double,complex,double*/);
extern double EpsMach(/*void*/);
extern complex cadd(/*complex,complex*/);
extern complex cmult(/*complex,complex*/);
extern complex cdiv(/*complex,complex*/);
extern complex csub(/*complex,complex*/);
extern complex cconj(/*complex*/);
extern complex cexp(/*double,double*/);
extern complex clog(/*complex*/);
extern complex mob_trans(/*complex,complex*/);
extern complex mob_norm(/*complex,complex,complex*/);
extern complex mob_norm_inv(/*complex,complex,complex*/);
extern complex mob_rotate(/*complex,double*/);
extern complex mobius(/*&Mobius,complex,int*/);
extern complex det(/*Mobius*/);
extern Mobius matrix_product(/*Mobius,Mobius*/);
extern Mobius mult_mobius(/*Mobius,Mobius,int*/);
extern Mobius zero_inf(/*complex,complex,double,double,double */);
extern Mobius ident_mob();
extern Mobius inv_mob(/*Mobius*/);
extern Mobius standard_mob(/*complex,complex*/);
extern Mobius auto_abAB(/*complex,complex,complex,complex,&double*/);
