/***************************************************************************
                          sound_driver_oss.cpp  -  description
                             -------------------
    begin                : Sun Jan 28 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sound_driver_oss.h"
#include "math.h"

#define AUDIO_DEVICE "/dev/dsp"

int Sound_Driver_OSS::init() {

	int fragment_size;
	int play_stereo,play_rate;
	int orig_precision,orig_stereo;
	long supported_formats;
	audio_buf_info buffinf;
 	int request_buffer_size;

	if (mix_frequency==-1) {
         	
		ERROR("DEVICE DRIVER OSS NOT CONFIGURED");
		return FUNCTION_FAILED;

	}

	if ( (sound_fd=open(AUDIO_DEVICE,O_WRONLY))<0 ) {

		return SOUND_DRIVER_ERROR_OPENING_DEVICE;
	}



	if (mix_buffersize<512) mix_buffersize=512;

	fragsize=9+(int)(log((float)(mix_buffersize >> 9))/log(2.0) );

//	fragsize = 10; //13?
	numfrags = 7;


	fragment_size=(numfrags<<16)|fragsize;
	
	if( ioctl(sound_fd,SNDCTL_DSP_SETFRAGMENT,&fragment_size)<0 ) {

		finish();
		return SOUND_DRIVER_ERROR_CONFIGURING_DEVICE;
	}


/* Ask device for supported formats */
	if(ioctl(sound_fd,SNDCTL_DSP_GETFMTS,&supported_formats)<0) {

		finish();
		return SOUND_DRIVER_ERROR_CONFIGURING_DEVICE;
	}

	orig_precision=play_precision=(mix_16bits)?AFMT_S16_NE:AFMT_U8;


	if(!(supported_formats & play_precision)) {

		/* Device does not support the format we would prefer... */
	        /* We could try 8 bit sound if available */

		if(play_precision==AFMT_S16_NE &&(supported_formats&AFMT_U8)) {

			ERROR("AUDIO DOESNT SUPPORT EITHER 16bits or 8bits!");
			finish();
			return FUNCTION_FAILED;
		}
	}

	if ( (ioctl(sound_fd,SNDCTL_DSP_SETFMT,&play_precision)<0 ) && ( orig_precision!=play_precision )) {

		finish();
		return SOUND_DRIVER_ERROR_CONFIGURING_DEVICE;
	}

	orig_stereo=play_stereo=(mix_stereo)?2:1;

	if ( ioctl(sound_fd,SNDCTL_DSP_CHANNELS,&play_stereo)<0 ) {

		finish();
		return SOUND_DRIVER_ERROR_CONFIGURING_DEVICE;
	}

	play_rate=mix_frequency;

	if ( (ioctl(sound_fd,SNDCTL_DSP_SPEED,&play_rate)<0) ) {

		finish();
		return SOUND_DRIVER_ERROR_CONFIGURING_DEVICE;
	}


	/* This call fails on Linux/PPC */
	if( (ioctl(sound_fd,SNDCTL_DSP_GETOSPACE,&buffinf)<0) ) {

		ioctl(sound_fd,SNDCTL_DSP_GETBLKSIZE,&buffinf.fragsize);
	}

	

	(void*)audiobuffer=calloc(1,buffinf.fragsize);

	if ( audiobuffer==NULL ) {

		finish();
		return SOUND_DRIVER_ERROR_CONFIGURING_DEVICE;
	}


	buffersize = buffinf.fragsize;

	mixer->set_mix_frequency(play_rate);
	mixer->set_mix_stereo(((play_stereo==2)?true:false));
	mixer->set_mix_16bits((play_precision==AFMT_S16_NE));

	mix_frequency=play_rate;

	mix_stereo=((play_stereo==2)?true:false);
	mix_16bits=(play_precision==AFMT_S16_NE);
	mix_buffersize=buffersize;

	active=true;
       	mixer->request_player_data();
       	
	return FUNCTION_SUCCESS;
}

bool Sound_Driver_OSS::finish() {

	if ( sound_fd>=0 ) close(sound_fd);

	if (audiobuffer!=NULL) free(audiobuffer);
	audiobuffer=NULL;	

	active=false;

	return true;
}


bool Sound_Driver_OSS::update() {

	int done;
	audio_buf_info buffinf;

	if (!active) return false;
	
	for (;;) {

		if ((ioctl(sound_fd,SNDCTL_DSP_GETOSPACE,&buffinf)<0)) {

			buffinf.fragments--;
			buffinf.fragsize = buffinf.bytes = buffersize;
		}

                if(!buffinf.fragments) break;

		done=mixer->write_bytes(audiobuffer,buffinf.fragsize>buffinf.bytes?buffinf.bytes:buffinf.fragsize);

                write(sound_fd,audiobuffer,done);
	}		

	return true;	
}
int Sound_Driver_OSS::get_mix_frequency() {

 	return mix_frequency;
}
bool Sound_Driver_OSS::get_mix_stereo() {

 	return mix_stereo;
}

bool Sound_Driver_OSS::get_mix_16bits() {

	return mix_16bits;

}
int Sound_Driver_OSS::get_mix_buffer_size() {

  	int real_buffsize=mix_buffersize;
/*  	if (mix_stereo)
   		real_buffsize*=2;*/
  	if (mix_16bits)
   		real_buffsize*=2;

	return real_buffsize;
}

Sound_Driver_OSS::Sound_Driver_OSS(){

	fragsize = 14;
	numfrags = 16;

	audiobuffer = NULL;
	sound_fd=-1;

	active=false;
}
Sound_Driver_OSS::~Sound_Driver_OSS(){

}
