/***************************************************************************
                          song.h  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SONG_H
#define SONG_H


/**Song Class
  *@author Juan Linietsky
  */
/******************************
 song.h
 --------

Overall Song structure!
********************************/

#include "order.h"
#include "pattern.h"
#include "sample.h"
#include "instrument.h"


#define MAX_PATTERNS 200
#define MAX_ORDERS 255
#define MAX_SAMPLES 99
#define MAX_INSTRUMENTS 99

class Song {

	Order order[MAX_ORDERS];
	Pattern pattern[MAX_PATTERNS];
	Sample sample[MAX_SAMPLES];
 	Instrument instrument[MAX_INSTRUMENTS];

	struct Song_Variables { // variables that wont change in playback

         	string name;
		string filename;
		string message;

		int row_highlight_minor;
		int row_highlight_major;

		Uint8 mixing_volume;
		Uint8 stereo_separation;

		bool use_stereo;
		bool use_instruments;
		bool use_linear_slides;

		bool old_effects;
		bool compatible_gxx;

	};

	struct Initial_Variables { // Initial values used for playback

        	struct Channel_State {

			Uint8 pan,volume; // 0--64
			bool surround;
			bool mute;
		};
	
		Uint8 global_volume;
		Uint8 speed;
		Uint8 tempo;	

		Channel_State channel[PATTERN_WIDTH];
	};

public:
	/* variables */

	Song_Variables variables;
	Initial_Variables initial_variables;	

	/* retrieving */
	Pattern* get_pattern(int p_pattern);
	Sample* get_sample(int p_sample);
	Instrument* get_instrument(int p_instrument);

	Order get_order(int p_position);
	Order get_next_order(int p_position);
	int get_used_orders_amount();
	int get_patterns_used();
        int find_pattern_in_orderlist(int p_pattern);

	/* setting */
	void set_order(int p_position,Order p_order);

	/* get max values */

	int get_max_orders() { return MAX_ORDERS; };
	int get_max_patterns() { return MAX_PATTERNS; };
	int get_max_samples() { return MAX_SAMPLES; };
	int get_max_instruments() { return MAX_INSTRUMENTS; };
	int get_max_used_pattern() { return 25; };

	/* utils */

	void set_instrument_mode();
	void set_sample_mode();
        int find_unused_instrument();
        int find_sample_in_instrument(int p_sample);
        int find_first_sample_in_instrument(int p_instrument);
        int find_unused_sample_slot();

        void reset_data();

	/* Loading */

	Song();
	~Song();

};

#endif
