/***************************************************************************
                          envelope.cpp  -  description
                             -------------------
    begin                : Sun Mar 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "envelope.h"

Envelope::Envelope() {

	reset();
}

void Envelope::reset() {


	on=false;
	carry=false;
	loop_on=false;
	loop_begin_node=0;
	loop_end_node=0;
	sustain_loop_on=false;
	sustain_loop_begin_node=0;
	sustain_loop_end_node=0;
	node_count=0;
}

int Envelope::get_height_at_pos(int pos) {

	int begin_x,begin_y;
	int end_x,end_y,xdif;
	int count=0;
	int limit=-1;

	if (node_count<2) return NO_ENVELOPE_POINT;

	while ((count<node_count) && (limit==-1)) {

		if (node[count].tick_offset>=pos) limit=count;
		count++;
	}

	if (pos==0) return node[0].value;

	if (limit==-1) return NO_ENVELOPE_POINT;

	begin_x=node[limit-1].tick_offset;
	end_x=node[limit].tick_offset;
	begin_y=node[limit-1].value;
	end_y=node[limit].value;

	xdif=end_x-begin_x;
	return begin_y+((pos-begin_x)*(end_y-begin_y))/(xdif?xdif:1);
}

void Envelope::set_position(int p_node,int p_x,int p_y) {

	if (p_node>=node_count) return;

	if (p_node==0) {

		p_x=0;

	} else if (p_x<=node[p_node-1].tick_offset) {

		p_x=node[p_node-1].tick_offset+1;

	} else if ((p_node<node_count-1) && (p_x>=node[p_node+1].tick_offset)) {

		p_x=node[p_node+1].tick_offset-1;
	}

	if (p_x>=9999) p_x=9999;

	if (p_y>max_value) p_y=max_value;

	if (envelope_signed) {

		if (p_y<(0-max_value)) p_y=0-max_value;
	} else {

		if (p_y<0) p_y=0;
	}

        node[p_node].tick_offset=p_x;
        node[p_node].value=p_y;
	
}

int Envelope::add_position(int p_x,int p_y) {


	if (node_count==MAX_ENVELOPE_POINTS) return -1;

	int i,new_node;

	// if this is assigning an existing node, let's quit.
	for (i=0;i<node_count;i++) if (p_x==node[i].tick_offset) return -1;

	i=0;
	while ((i<node_count) && (p_x>=node[i].tick_offset)) i++;
	
	new_node=i;
	node_count++;

	if (loop_begin_node>=new_node) loop_begin_node++;
	if (loop_end_node>=new_node) loop_end_node++;
	if (sustain_loop_begin_node>=new_node) sustain_loop_begin_node++;
	if (sustain_loop_end_node>=new_node) sustain_loop_end_node++;

	for (i=node_count-1;i>new_node;i--) node[i]=node[i-1];

        set_position(new_node,p_x,p_y);

	return new_node;
	
}

void Envelope::set_loop_begin(int pos) {

	if ((pos<0) || (pos>=node_count)) return;

	loop_begin_node=pos;

	if (loop_end_node<loop_begin_node) loop_end_node=loop_begin_node;


}

void Envelope::set_loop_end(int pos) {

	if ((pos<0) || (pos>=node_count)) return;

        loop_end_node=pos;
	
	if (loop_end_node<loop_begin_node) loop_begin_node=loop_end_node;


}


void Envelope::set_sustain_loop_begin(int pos) {

	if ((pos<0) || (pos>=node_count)) return;

	sustain_loop_begin_node=pos;

	if (sustain_loop_end_node<sustain_loop_begin_node) sustain_loop_end_node=sustain_loop_begin_node;


}

void Envelope::set_sustain_loop_end(int pos) {

	if ((pos<0) || (pos>=node_count)) return;

        sustain_loop_end_node=pos;
	
	if (sustain_loop_end_node<sustain_loop_begin_node) sustain_loop_begin_node=sustain_loop_end_node;


}


void Envelope::del_position(int p_node) {

	if ((node_count<3) || (p_node<=0) || (p_node>=node_count)) return;

	int i;

	if (loop_begin_node>=p_node) loop_begin_node--;
	if (loop_end_node>=p_node) loop_end_node--;
	if (sustain_loop_begin_node>=p_node) sustain_loop_begin_node--;
	if (sustain_loop_end_node>=p_node) sustain_loop_end_node--;

	for (i=p_node;i<node_count-1;i++) node[i]=node[i+1];

	node_count--;
	
}
