/***************************************************************************
                          interface_update_instruments.cpp  -  description
                             -------------------
    begin                : Sat Jan 27 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "interface.h"


void Interface::update_clist_instrments_names() {

	int i;

	clist_instrments_names.freeze();

	for (i=0;i<MAX_INSTRUMENTS;i++) {
  		clist_instrments_names.set_text(i,1,song->get_instrument(i)->name);
	}

	clist_instrments_names.thaw();

}

void Interface::update_selected_instrument_info() {

	#define SET_SPIN_MAX(spinbtn,maxval) tmp_adjustment=spinbtn->get_adjustment(); tmp_adjustment->set_upper(maxval); spinbtn->set_adjustment(tmp_adjustment)
	int i=selected_instrument;
	Gtk::Adjustment *tmp_adjustment;

	selected_instrument_updating_in_progress=true;

	
        SET_SPIN_MAX(spinbutton_instruments_volume_envelope_loop_begin,song->get_instrument(selected_instrument)->volume.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_volume_envelope_loop_end,song->get_instrument(selected_instrument)->volume.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_volume_envelope_susloop_begin,song->get_instrument(selected_instrument)->volume.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_volume_envelope_susloop_end,song->get_instrument(selected_instrument)->volume.envelope.node_count-1);

        spinbutton_instruments_volume_envelope_loop_begin->set_value(song->get_instrument(selected_instrument)->volume.envelope.loop_begin_node);
        spinbutton_instruments_volume_envelope_loop_end->set_value(song->get_instrument(selected_instrument)->volume.envelope.loop_end_node);
        spinbutton_instruments_volume_envelope_susloop_begin->set_value(song->get_instrument(selected_instrument)->volume.envelope.sustain_loop_begin_node);
        spinbutton_instruments_volume_envelope_susloop_end->set_value(song->get_instrument(selected_instrument)->volume.envelope.sustain_loop_end_node);


        SET_SPIN_MAX(spinbutton_instruments_pan_envelope_loop_begin,song->get_instrument(selected_instrument)->panning.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_pan_envelope_loop_end,song->get_instrument(selected_instrument)->panning.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_pan_envelope_susloop_begin,song->get_instrument(selected_instrument)->panning.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_pan_envelope_susloop_end,song->get_instrument(selected_instrument)->panning.envelope.node_count-1);

        spinbutton_instruments_pan_envelope_loop_begin->set_value(song->get_instrument(selected_instrument)->panning.envelope.loop_begin_node);
        spinbutton_instruments_pan_envelope_loop_end->set_value(song->get_instrument(selected_instrument)->panning.envelope.loop_end_node);
        spinbutton_instruments_pan_envelope_susloop_begin->set_value(song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_begin_node);
        spinbutton_instruments_pan_envelope_susloop_end->set_value(song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_end_node);

        SET_SPIN_MAX(spinbutton_instruments_frequency_envelope_loop_begin,song->get_instrument(selected_instrument)->pitch.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_frequency_envelope_loop_end,song->get_instrument(selected_instrument)->pitch.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_frequency_envelope_susloop_begin,song->get_instrument(selected_instrument)->pitch.envelope.node_count-1);
        SET_SPIN_MAX(spinbutton_instruments_frequency_envelope_susloop_end,song->get_instrument(selected_instrument)->pitch.envelope.node_count-1);

        spinbutton_instruments_frequency_envelope_loop_begin->set_value(song->get_instrument(selected_instrument)->panning.envelope.loop_begin_node);
        spinbutton_instruments_frequency_envelope_loop_end->set_value(song->get_instrument(selected_instrument)->panning.envelope.loop_end_node);
        spinbutton_instruments_frequency_envelope_susloop_begin->set_value(song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_begin_node);
        spinbutton_instruments_frequency_envelope_susloop_end->set_value(song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_end_node);

	
	checkbutton_instruments_volume_envelope.set_active(song->get_instrument(selected_instrument)->volume.envelope.on);
	checkbutton_instruments_volume_envelope_carry.set_active(song->get_instrument(selected_instrument)->volume.envelope.carry);
	checkbutton_instruments_volume_envelope_loop.set_active(song->get_instrument(selected_instrument)->volume.envelope.loop_on);
	checkbutton_instruments_volume_envelope_susloop.set_active(song->get_instrument(selected_instrument)->volume.envelope.sustain_loop_on);

	checkbutton_instruments_pan_envelope.set_active(song->get_instrument(selected_instrument)->panning.envelope.on);
	checkbutton_instruments_pan_envelope_carry.set_active(song->get_instrument(selected_instrument)->panning.envelope.carry);
	checkbutton_instruments_pan_envelope_loop.set_active(song->get_instrument(selected_instrument)->panning.envelope.loop_on);
	checkbutton_instruments_pan_envelope_susloop.set_active(song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_on);

//heckbutton_instruments_frequency_envelope.set_active(song->get_instrument(selected_instrument)->pitch.envelope.on);
	checkbutton_instruments_frequency_envelope_carry.set_active(song->get_instrument(selected_instrument)->pitch.envelope.carry);
	checkbutton_instruments_frequency_envelope_loop.set_active(song->get_instrument(selected_instrument)->pitch.envelope.loop_on);
	checkbutton_instruments_frequency_envelope_susloop.set_active(song->get_instrument(selected_instrument)->pitch.envelope.sustain_loop_on);

	spinbutton_instruments_global_volume->set_value(song->get_instrument(selected_instrument)->volume.global_amount);
	spinbutton_instruments_volume_fadeout->set_value(song->get_instrument(selected_instrument)->volume.fadeout);
	spinbutton_instruments_volume_swing->set_value(song->get_instrument(selected_instrument)->volume.random_variation);

	spinbutton_instruments_pan_default_value->set_value(song->get_instrument(selected_instrument)->panning.default_amount);
	spinbutton_instruments_pan_pitch_center->set_value(song->get_instrument(selected_instrument)->panning.pitch_center);
	spinbutton_instruments_pitch_pan_separation->set_value(song->get_instrument(selected_instrument)->panning.pitch_separation);
	spinbutton_instruments_pan_swing->set_value(song->get_instrument(selected_instrument)->panning.random_variation);

        checkbutton_instruments_pitch_envelope.set_active(song->get_instrument(selected_instrument)->pitch.envelope.on);
	checkbutton_instruments_pitch_envelope_filter.set_active(song->get_instrument(selected_instrument)->pitch.use_as_filter);
	checkbutton_instruments_pan_default.set_active(song->get_instrument(selected_instrument)->panning.use_default);

	entry_instruments_pan_pitch_center.set_text(editor.get_single_note_string(song->get_instrument(selected_instrument)->panning.pitch_center));

        switch (song->get_instrument(selected_instrument)->NNA_type) {

		case Instrument::NNA_NOTE_CUT: {

			radiobutton_instruments_nna_note_cut->set_active(true);

		} break;

		case Instrument::NNA_NOTE_OFF: {

			radiobutton_instruments_nna_note_off->set_active(true);
		} break;

		case Instrument::NNA_NOTE_CONTINUE: {

			radiobutton_instruments_nna_note_continue->set_active(true);
		} break;

		case Instrument::NNA_NOTE_FADE: {

			radiobutton_instruments_nna_note_fade->set_active(true);

		} break;

	}

        switch (song->get_instrument(selected_instrument)->duplicate_check_type) {

		case Instrument::DCT_DISABLED:{

			radiobutton_instruments_dca_disabled->set_active(true);
		}break;
		case Instrument::DCT_NOTE:{

			radiobutton_instruments_dca_note->set_active(true);
		}break;
		case Instrument::DCT_SAMPLE:{

			radiobutton_instruments_dca_sample->set_active(true);
		}break;
		case Instrument::DCT_INSTRUMENT:{

			radiobutton_instruments_dca_disabled_instrument->set_active(true);
		}break;

	}

        switch (song->get_instrument(selected_instrument)->duplicate_check_action) {
	
		case Instrument::DCA_NOTE_CUT:{

			radiobutton_instruments_dca_note_cut->set_active(true);
		}break;
		case Instrument::DCA_NOTE_OFF:{


			radiobutton_instruments_dca_note_off->set_active(true);
		}break;
		case Instrument::DCA_NOTE_FADE:{

			radiobutton_instruments_dca_note_fade->set_active(true);
		}break;
	}


	if (song->variables.use_instruments && !notebook2.is_visible()) notebook2.show();
	if (!song->variables.use_instruments && notebook2.is_visible()) notebook2.hide();

      	entry_instrument_name.set_text(song->get_instrument(selected_instrument)->name);

	envelope_instruments_volume.set_envelope(&song->get_instrument(i)->volume.envelope);
        envelope_instruments_pan.set_envelope(&song->get_instrument(i)->panning.envelope);
        envelope_instruments_frequency.set_envelope(&song->get_instrument(i)->pitch.envelope);
        equivtable_instruments.link_to_instrument(song->get_instrument(i));

// hbox_filter_cutoff.pack_start(checkbutton_instruments_use_default_cutoff,false,false,0);
//   hbox_filter_cutoff.pack_end(*spinbutton_instruments_default_cutoff,false,false,0);
//   hbox_filter_Q.pack_start(checkbutton_instruments_use_default_Q,false,false,0);
//   hbox_filter_Q.pack_end(*spinbutton_instruments_default_Q,false,false,0);

	checkbutton_instruments_use_default_cutoff.set_active(song->get_instrument(selected_instrument)->pitch.use_default_cutoff);
	spinbutton_instruments_default_cutoff->set_value(song->get_instrument(selected_instrument)->pitch.default_cutoff);
	checkbutton_instruments_use_default_Q.set_active(song->get_instrument(selected_instrument)->pitch.use_default_Q);
	spinbutton_instruments_default_Q->set_value(song->get_instrument(selected_instrument)->pitch.default_Q);


        realtime_keyboard.instrument_set(selected_instrument);

	selected_instrument_updating_in_progress=false;

}