/***************************************************************************
                          interface_callbacks_orderpan.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

gint Interface::orderlist_key_press_callback(GdkEventKey* event) {

	bool stop_signal=true;

	switch (event->keyval) {

		case GDK_Up: {

			editor.orderlist_move_up();
 				
		} break;

		case GDK_Down: {

			editor.orderlist_move_down();
		} break;

		case GDK_Left: {

			editor.orderlist_move_left(); 		
		} break;
		case GDK_Right: {

			editor.orderlist_move_right();	
		} break;
		case GDK_Page_Up: {

			editor.orderlist_page_up();	
		 		
		} break;
		case GDK_Page_Down: {

			editor.orderlist_page_down();	 		
		} break;        	

		case '.':{

			editor.orderlist_clear_order();
		} break;
		case GDK_Insert: {

			editor.orderlist_insert();		
		} break;
		case GDK_Delete: {

			editor.orderlist_delete();				
		} break;
		case GDK_KP_Add: {

			editor.orderlist_add_separator();
		} break;
		default: {
			if ((event->keyval>='0') && (event->keyval<='9')) {

				editor.orderlist_insert_value(event->keyval-'0');
			} else {

				stop_signal=false;
			}
		}break;

	}

	orderlist_ord_pan.queue_draw();

	if (stop_signal) {

		gtk_signal_emit_stop_by_name(GTK_OBJECT(orderlist_ord_pan.gtkobj()),"key_press_event");

		return TRUE;
	} else {

		return FALSE;
	}


}

void Interface::on_orderpan_pan_changed(int i) {

	if (orderpan_page_updating_in_progress) return;

	song->initial_variables.channel[i].pan=panvol_defaults[i].spinbutton_order_pan_pan->get_value_as_int();

}
void Interface::on_orderpan_volume_changed(int i) {

	if (orderpan_page_updating_in_progress) return;

	song->initial_variables.channel[i].volume=panvol_defaults[i].spinbutton_order_pan_volume->get_value_as_int();
}
void Interface::on_orderpan_suround_changed(int i) {

	if (orderpan_page_updating_in_progress) return;

	song->initial_variables.channel[i].surround=panvol_defaults[i].checkbutton_order_pan_surround.get_active();

}
void Interface::on_orderpan_mute_changed(int i) {

	if (orderpan_page_updating_in_progress) return;

	song->initial_variables.channel[i].mute=panvol_defaults[i].checkbutton_order_pan_mute.get_active();
}