#include <stdio.h>
#include <ncurses.h>
#include "color.h"

unsigned short int is_field(char *field, const char *fieldname)
{
    if (!strncasecmp(field, fieldname, strlen(fieldname)))
	return FIELD_MATCH;
    else
	return FIELD_NOT_MATCH;
}

unsigned char *ltrim(char *str)
{
    return str+strspn(str, " \t");
}

unsigned char *rtrim(char *str)
{
    char *p;

    for (p=str; *p; ++p);
    while ( (*--p == ' ') || (*p == '\t') );
    *++p='\0';
    return str;
}

unsigned int parse_conf_line(char *line){
    if ((line[0]=='#') || (strlen(line)<=1)) 
	return CONF_COMMENT;
    else {
	if (is_field(line, "Color1_fore")) return CONF_COLOR1_FORE;
	if (is_field(line, "Color1_bg")) return CONF_COLOR1_BG;
	if (is_field(line, "Color2_fore")) return CONF_COLOR2_FORE;
	if (is_field(line, "Color2_bg")) return CONF_COLOR2_BG;
	if (is_field(line, "Color3_fore")) return CONF_COLOR3_FORE;
	if (is_field(line, "Color3_bg")) return CONF_COLOR3_BG;
	if (is_field(line, "Color4_fore")) return CONF_COLOR4_FORE;
	if (is_field(line, "Color4_bg")) return CONF_COLOR4_BG;
	if (is_field(line, "Color5_fore")) return CONF_COLOR5_FORE;
	if (is_field(line, "Color5_bg")) return CONF_COLOR5_BG;
	if (is_field(line, "Color6_fore")) return CONF_COLOR6_FORE;
	if (is_field(line, "Color6_bg")) return CONF_COLOR6_BG;
	if (is_field(line, "Color7_fore")) return CONF_COLOR7_FORE;
	if (is_field(line, "Color7_bg")) return CONF_COLOR7_BG;
	if (is_field(line, "Color8_fore")) return CONF_COLOR8_FORE;
	if (is_field(line, "Color8_bg")) return CONF_COLOR8_BG;
	if (is_field(line, "Color9_fore")) return CONF_COLOR9_FORE;
	if (is_field(line, "Color9_bg")) return CONF_COLOR9_BG;
	if (is_field(line, "Color10_fore")) return CONF_COLOR10_FORE;
	if (is_field(line, "Color10_bg")) return CONF_COLOR10_BG;
    }
}

static int set_color(char *source)
{
    if (ltrim(source)[0]!='=')
	return -1;
    if (!strncasecmp(ltrim(ltrim(source)+1), "BLACK", 5)) return COLOR_BLACK;
    if (!strncasecmp(ltrim(ltrim(source)+1), "RED", 3)) return COLOR_RED;
    if (!strncasecmp(ltrim(ltrim(source)+1), "GREEN", 5)) return COLOR_GREEN;
    if (!strncasecmp(ltrim(ltrim(source)+1), "YELLOW", 6)) return COLOR_YELLOW;
    if (!strncasecmp(ltrim(ltrim(source)+1), "BLUE", 4)) return COLOR_BLUE;
    if (!strncasecmp(ltrim(ltrim(source)+1), "MAGENTA", 7)) return COLOR_MAGENTA;
    if (!strncasecmp(ltrim(ltrim(source)+1), "CYAN", 4)) return COLOR_CYAN;
    if (!strncasecmp(ltrim(ltrim(source)+1), "WHITE", 5)) return COLOR_WHITE;
    
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_BLACK", 10)) return (COLOR_BLACK|A_BOLD);
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_RED", 8)) return (A_BOLD|COLOR_RED);
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_GREEN", 10)) return COLOR_GREEN|A_BOLD;
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_YELLOW", 11)) return COLOR_YELLOW|A_BOLD;
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_BLUE", 9)) return COLOR_BLUE|A_REVERSE;
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_MAGENTA", 12)) return COLOR_MAGENTA|A_BOLD;
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_CYAN", 9)) return COLOR_CYAN|A_BOLD;
    if (!strncasecmp(ltrim(ltrim(source)+1), "BOLD_WHITE", 10)) return COLOR_WHITE|A_BOLD;
    return -1;
}

void init_curses_colors()
{
    FILE *color_conf;
    char line[999];
    int linecount=0;
    int colors[20];
    int i;
   
    sprintf(line, "%s/.cdw.colors", getenv("HOME"));
    if ((color_conf=fopen(line, "r"))==NULL) {
	init_pair(1, COLOR_CYAN, COLOR_BLUE);
	init_pair(2, COLOR_BLUE, COLOR_WHITE);
	init_pair(3, COLOR_RED, COLOR_BLUE);
	init_pair(4, COLOR_WHITE, COLOR_BLUE);
	init_pair(5, COLOR_BLACK, COLOR_BLUE);
	init_pair(6, COLOR_WHITE, COLOR_BLACK);
	init_pair(7, COLOR_RED, COLOR_WHITE);
	init_pair(8, COLOR_YELLOW, COLOR_BLUE);
	init_pair(9, COLOR_BLACK, COLOR_WHITE);
	init_pair(10, COLOR_WHITE, COLOR_RED);
    } else {
	while (fgets(line, sizeof(line), color_conf)!=NULL){
	    linecount++;
	    switch (i=parse_conf_line(ltrim(line))) {
		case 0:
		    break;
		default:
		    if ( i%2==1 ) {
			if (i<=9) colors[i-1]=set_color(ltrim(line)+11);
			else colors[i-1]=set_color(ltrim(line)+12);
		    } else {
			if (i<=9) colors[i-1]=set_color(ltrim(line)+9);
			else colors[i-1]=set_color(ltrim(line)+10);
		    }
		    break;
	    }
	}
	for (i=1; i<=20; i++) 
	    init_pair(i, colors[(i*2)-2], colors[(i*2)-1]);
	    //printf("Color[%d]=%d\n", i, colors[i-1]);
	fclose(color_conf);
    }
}
