/* catsglue.S */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

	.text

#define ATAG_NONE	0
#define ATAG_CORE	0x54410001
#define ATAG_MEM	0x54410002
#define ATAG_MEMCLK	0x41000402
#define ATAG_CMDLINE	0x54410009
#define ATAG_REVISION	0x54410007
#define ATAG_INITRD	0x54410005

	.globl	_start
_start:
	.word	0x0b018f00
	.word	0		/* size goes here */
	.word	0
	.word	0
	.word	0
	.word	0x10000020
	.word	0
	.word	0

	mov	ip, #0
	mcr	p15, 0, ip, c7, c7, 0	@ invalidate I,D caches
	mcr	p15, 0, ip, c7, c10, 4	@ drain WB

	b	1f

	.org	0x80
root_dev:
	.word	0
initrd_start:
	.word	0
initrd_size:
	.word	0

	.org	0x400

1:
	mov	sl, #0x100
	orr	sl, sl, #0x10000000
	mov	ip, #5			@ size
	str	ip, [sl], #4
	ldr	ip, =ATAG_CORE
	str	ip, [sl], #4
	mov	ip, #1			@ flags
	str	ip, [sl], #4
	mov	ip, #4096		@ page size
	str	ip, [sl], #4
	ldr	ip, root_dev
	str	ip, [sl], #4		@ root device

	ldr	r1, [r0, #12]
	bic	r1, r1, #0xe0000000

1:	ldrb	r3, [r1]
	teq	r3, #0
	beq	1f
	add	r1, r1, #1
	teq	r3, #' '
	bne	1b

1:	mov	r2, #0
1:	ldrb	r3, [r1, r2]
	add	r2, r2, #1
	teq	r3, #0
	bne	1b

	add	r2, r2, #4

	mov	r2, r2, lsr #2
	add	r2, r2, #2
	str	r2, [sl], #4
	ldr	ip, =ATAG_CMDLINE
	str	ip, [sl], #4
1:	ldrb	ip, [r1], #1
	strb	ip, [sl], #1
	teq	ip, #0
	bne	1b
	add	sl, sl, #3
	bic	sl, sl, #3

	mov	ip, #3
	str	ip, [sl], #4
	ldr	ip, =ATAG_MEMCLK
	str	ip, [sl], #4
	ldr	ip, [r0, #28]
	str	ip, [sl], #4

	mov	ip, #4
	str	ip, [sl], #4
	ldr	ip, =ATAG_MEM
	str	ip, [sl], #4
	ldr	r2, [r0, #20]
	ldr	r3, [r0, #24]
	sub	r3, r3, r2
	str	r3, [sl], #4
	str	r2, [sl], #4

	ldr	r2, initrd_start
	teq	r2, #0
	beq	no_initrd
	ldr	r3, initrd_size
	orr	r2, r2, #0x10000000
	mov	r4, #0x10000000
	orr	r4, r4, #0x00800000
	mov	r6, #0
1:	ldr	r5, [r2, r6]
	str	r5, [r4, r6]
	add	r6, r6, #4
	cmp	r6, r3
	ble	1b
	mov	r4, #0xc0000000
	orr	r4, r4, #0x00800000
	mov	ip, #4
	str	ip, [sl], #4
	ldr	ip, =ATAG_INITRD
	str	ip, [sl], #4
	str	r4, [sl], #4
	str	r3, [sl], #4
no_initrd:

	mov	ip, #0
	str	ip, [sl], #4

	mov	ip, #0
	mcr	p15, 0, ip, c7, c10, 4	@ drain WB

	mov	r0, #0			@ set up args
	mov	r1, #6
	mov	r4, #0x8000
	mov	r5, #0x130		@ turn MMU off
	mcr	p15, 0, r5, c1, c0
	mov	r0, r0			@ wait for pipeline
	mov	pc, r4			@ jump to kernel

	.ltorg
