/* dumpclass.c -- display contents of a class_file
 * Written by Charles Briscoe-Smith; refer to the file LEGAL for details.
 */

/* Interface definitions */

/* Dump the contents of class to stdout in human-readable form.  */
extern void dumpclass(const class_file class);


#ifndef SEEN_dumpclass_h

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "types.h"

static void
showaccessflags(u2 access, int in_method)
{
  printf("Access flags:%s%s%s%s%s\n",
         access & ACC_public ? " public" : "",
         access & ACC_private ? " private" : "",
         access & ACC_protected ? " protected" : "",
         access & ACC_final ? " final" : "",
	 access & ACC_volatile ? " volatile" : "",
	 access & ACC_transient ? " transient" : "",
	 access & ACC_native ? " native" : "",
	 access & ACC_abstract ? " abstract" : "",
	 access & ACC_synchronised & in_method ? " synchronised" : "",
	 access & ACC_interface ? " interface" : "",
	 access & ACC_super &!in_method ? "" : " (without super flag; generated by old Sun compiler)",
	 );
}

void
dumpclass(const class_file *class)
{
  u4 count;

  printf("Version: major %d, minor %d\n", class->major_version,
					  class->minor_version);
  printf("Number of constants: %d\n", class->const_count);
  cp=(cp_info*) calloc(const_count, sizeof(cp_info));
  tag=(u2*) calloc(const_count, sizeof(u2));
  for (i1=1; i1<const_count; i1++) {
    tag[i1]=readconst(fp, &cp[i1]);
    if (tag[i1]==CONSTANT_Long
       || tag[i1]==CONSTANT_Double) {
      i1++;
    }
  }
  for (i1=0; i1<const_count; i1++) {
    u4f u4f;
    u8d u8d;
    printf("Constant %d: ", i1);
    if (i1==0) printf("reserved\n");
    else if (tag[i1-1]==CONSTANT_Long
	     || tag[i1-1]==CONSTANT_Double) printf("continuation word\n");
    else switch (tag[i1]) {
    case CONSTANT_Class:
      printf("Class: %d (%s)\n", cp[i1].u2,
	     cp[cp[i1].u2].utf8);
      break;
    case CONSTANT_Fieldref:
      printf("Fieldref: %d, %d (%s, %s, %s)\n",
             cp[i1].u2x2.i1,
             cp[i1].u2x2.i2,
	     cp[cp[cp[i1].u2x2.i1].u2].utf8,
	     cp[cp[cp[i1].u2x2.i2].u2x2.i1].utf8,
	     cp[cp[cp[i1].u2x2.i2].u2x2.i2].utf8);
      break;
    case CONSTANT_Methodref:
      printf("Methodref: %d, %d (%s, %s, %s)\n",
             cp[i1].u2x2.i1,
	     cp[i1].u2x2.i2,
	     cp[cp[cp[i1].u2x2.i1].u2].utf8,
	     cp[cp[cp[i1].u2x2.i2].u2x2.i1].utf8,
	     cp[cp[cp[i1].u2x2.i2].u2x2.i2].utf8);
      break;
    case CONSTANT_InterfaceMethodref:
      printf("InterfaceMethodref: %d, %d (%s, %s, %s)\n",
             cp[i1].u2x2.i1,
             cp[i1].u2x2.i2,
	     cp[cp[cp[i1].u2x2.i1].u2].utf8,
	     cp[cp[cp[i1].u2x2.i2].u2x2.i1].utf8,
	     cp[cp[cp[i1].u2x2.i2].u2x2.i2].utf8);
      break;
    case CONSTANT_String:
      printf("String: %d (\"%s\")\n", cp[i1].u2,
	     cp[cp[i1].u2].utf8);
      break;
    case CONSTANT_Integer:
      printf("Integer: %ld\n", cp[i1].u4);
      break;
    case CONSTANT_Float:
      u4f.u=cp[i1].u4;
      printf("Float: %g\n", u4f.f);
      break;
    case CONSTANT_Long:
      printf("Long: %qd\n", ((u8) cp[i1].u4 << 32) + cp[i1+1].u4);
      break;
    case CONSTANT_Double:
#if defined(__arm__) && !defined (__VFP_FP__)
      u8d.u=((u8) cp[i1+1].u4 << 32) + cp[i1].u4;
#else
      u8d.u=((u8) cp[i1].u4 << 32) + cp[i1+1].u4;
#endif
      printf("Double: %g\n", u8d.d);
      break;
    case CONSTANT_NameAndType:
      printf("NameAndType: %d, %d\n", cp[i1].u2x2.i1, cp[i1].u2x2.i2);
      break;
    case CONSTANT_Utf8:
      printf("Utf8: \"%s\"\n", cp[i1].utf8);
      break;
    }
  }

  access=readu2(fp);
  this=readu2(fp);
  printf("This class: %d\n", this);
  super=readu2(fp);
  printf("Superclass: %d\n", super);
  iface_count=readu2(fp);
  printf("Number of interfaces: %d:", iface_count);
  ifaces=(u2*) calloc(iface_count, sizeof(u2));
  for (i1=0; i1<iface_count; i1++) {
    ifaces[i1]=readu2(fp);
    printf(" %d", ifaces[i1]);
  }
  field_count=readu2(fp);
  printf("\nNumber of fields: %d\n", field_count);
  meth_count=readu2(fp);
  printf("Number of methods: %d\n", meth_count);
  attr_count=readu2(fp);
  printf("Number of attributes: %d\n", attr_count);
  if (feof(fp)) {
    error("%s", "premature end of file");
  }
  return 0;
}

#endif /* SEEN_readclass_h */

