/* parsetree.c -- representation of a parsed Java-like source file
 * Generated automatically from parsetree.in
 */

#include "types.h"

enum namesort { PackageName, TypeName, ExpressionName, LvarName };

struct name {
	struct name *prefix;
	const char *id;
	int data;
	struct name *rest;
};

extern struct name *newname(struct name *prefix,
	const char *id,
	int data,
	struct name *rest);

enum typeid { Boolean, Byte, Short, Int, Long, Char, Float, Double,
              Ref, Null, Void };

struct type {
	int dims;
	enum typeid prim;
	struct name *ref;
};

extern struct type *newtype(int dims,
	enum typeid prim,
	struct name *ref);

extern struct type *arrayoftype(struct type *);
extern struct type *arrayoftypedepth(struct type *, int);
extern struct type *referencetype(struct name *);

extern void noteprimtype(enum typeid, int);
extern int getprimtypedepth(enum typeid);

extern struct type BooleanType, ByteType, ShortType, IntType, LongType;
extern struct type CharType, FloatType, DoubleType, NullType, VoidType;

extern struct type ObjectType, StringType;

struct typedecl {
	u2 modifiers;
	struct name *name;
	struct name *typeimports;
	struct name *typesearchpath;
	struct name *super;
	struct name *implements;
	int arrdepth;
	struct memberdecl *body;
	struct typedecl *rest;
};

extern struct typedecl *newtypedecl(u2 modifiers,
	struct name *name,
	struct name *typeimports,
	struct name *typesearchpath,
	struct name *super,
	struct name *implements,
	int arrdepth,
	struct memberdecl *body,
	struct typedecl *rest);

enum membertag { Field, Method, StaticInit, InstanceInit, Constructor };

union member { struct fielddecl *field;
               struct methoddecl *meth;
               struct stmt *init;
               struct constrdecl *constr;
};

struct memberdecl {
	enum membertag tag;
	union member content;
	struct memberdecl *rest;
};

extern struct memberdecl *newmemberdecl(enum membertag tag,
	union member content,
	struct memberdecl *rest);

struct fielddecl {
	u2 modifiers;
	struct type *type;
	struct vardecl *decls;
};

extern struct fielddecl *newfielddecl(u2 modifiers,
	struct type *type,
	struct vardecl *decls);

struct vardecl {
	char *name;
	int adddepth;
	struct expr *init;
	struct vardecl *rest;
};

extern struct vardecl *newvardecl(char *name,
	int adddepth,
	struct expr *init,
	struct vardecl *rest);

struct methoddecl {
	u2 modifiers;
	struct type *type;
	struct methodsig *sig;
	struct name *throws;
	struct name *overrides;
	struct stmt *body;
};

extern struct methoddecl *newmethoddecl(u2 modifiers,
	struct type *type,
	struct methodsig *sig,
	struct name *throws,
	struct name *overrides,
	struct stmt *body);

struct methodsig {
	char *name;
	struct formparlist *params;
};

extern struct methodsig *newmethodsig(char *name,
	struct formparlist *params);

extern int equalnames(struct name *, struct name *);
extern int equaltypes(struct type *, struct type *);
extern int equalsig(struct methodsig *, struct methodsig *);

struct formparlist {
	struct type *type;
	char *name;
	struct formparlist *rest;
};

extern struct formparlist *newformparlist(struct type *type,
	char *name,
	struct formparlist *rest);

struct constrdecl {
	u2 modifiers;
	struct methodsig *sig;
	struct name *throws;
	struct constinv *cons;
	struct stmt *body;
};

extern struct constrdecl *newconstrdecl(u2 modifiers,
	struct methodsig *sig,
	struct name *throws,
	struct constinv *cons,
	struct stmt *body);

struct constinv {
	char super;
	struct expr *arglist;
};

extern struct constinv *newconstinv(char super,
	struct expr *arglist);

enum stmttype { Localvar, If, While, For, Block, Empty, Exprstmt,
                Switch, Case, Default, Do, Break, Cont, Return, Throw,
                Try, NativeStmt };

struct stmt {
	enum stmttype tag;
	struct fielddecl *var;
	struct expr *expr;
	struct stmt *stmt1;
	struct stmt *stmt2;
	struct stmt *stmt3;
	struct stmt *stmt4;
	struct catchclause *catch;
	struct stmt *rest;
};

extern struct stmt *newstmt(enum stmttype tag,
	struct fielddecl *var,
	struct expr *expr,
	struct stmt *stmt1,
	struct stmt *stmt2,
	struct stmt *stmt3,
	struct stmt *stmt4,
	struct catchclause *catch,
	struct stmt *rest);

struct catchclause {
	struct formparlist *param;
	struct stmt *block;
	struct catchclause *rest;
};

extern struct catchclause *newcatchclause(struct formparlist *param,
	struct stmt *block,
	struct catchclause *rest);

enum exprtype { Assign, Multass, Divass, Remass, Addass, Subass,
                Lshiftass, Rshiftass, Urshiftass, Andass, Xorass, Orass,
                Cond, Condor, Condand, Or, Xor, And, Eq, Neq, Inst, Lt,
                Gt, Leq, Geq, Lshift, Rshift, Urshift, Add, Sub, Mult,
                Div, Rem, Cast, Not, Comp, Predec, Preinc, Postdec,
                Postinc, Plus, Minus, Name, Prim, Intlit, Longlit,
                Stringlit, Boollit, Charlit, Floatlit, Doublit, Nulllit,
                This, Localacc, New, Primfield, Super, Meth, Array,
                NullString, Arrayinit };

struct expr {
	enum exprtype tag;
	struct expr *exp1;
	struct expr *exp2;
	struct expr *exp3;
	struct type *type;
	struct name *name;
	s8 integ;
	const char *str;
	struct expr *rest;
};

extern struct expr *newexpr(enum exprtype tag,
	struct expr *exp1,
	struct expr *exp2,
	struct expr *exp3,
	struct type *type,
	struct name *name,
	s8 integ,
	const char *str,
	struct expr *rest);


#ifndef SEEN_parsetree_h

#include <stdlib.h>
#include <stdio.h>

#include "xmalloc.h"
#include "error.h"

struct type BooleanType = { 0, Boolean, 0 };
struct type ByteType = { 0, Byte, 0 };
struct type ShortType = { 0, Short, 0 };
struct type IntType = { 0, Int, 0 };
struct type LongType = { 0, Long, 0 };
struct type CharType = { 0, Char, 0 };
struct type FloatType = { 0, Float, 0 };
struct type DoubleType = { 0, Double, 0 };
struct type NullType = { 0, Null, 0 };
struct type VoidType = { 0, Void, 0 };

static struct name njava = { 0, "java", 0, 0 };
static struct name nlang = { &njava, "lang", 0, 0 };
static struct name nObject = { &nlang, "Object", 0, 0 };
static struct name nString = { &nlang, "String", 0, 0 };

struct type ObjectType = { 0, Ref, &nObject };
struct type StringType = { 0, Ref, &nString };

struct type *
arrayoftype(struct type *base)
{
	return arrayoftypedepth(base, 1);
}

struct type *
arrayoftypedepth(struct type *base, int depth)
{
	if (depth==0)
		return base;
	else
		return newtype(base->dims+depth, base->prim, base->ref);
}

struct type *
referencetype(struct name *ref)
{
	return newtype(0, Ref, ref);
}

int
equalnames(struct name *n1, struct name *n2)
{
	if (n1==0 && n2==0)
		return 1;

	if (n1==0 || n2==0)
		return 0;

	if (!equalnames(n1->prefix, n2->prefix))
		return 0;

	if (strcmp(n1->id, n2->id)!=0)
		return 0;

	return 1;
}

int
equaltypes(struct type *t1, struct type *t2)
{
	if (t1->dims!=t2->dims || t1->prim!=t2->prim)
		return 0;

	if (t1->prim==Ref && !equalnames(t1->ref, t2->ref))
		return 0;

	return 1;
}

int
equalsig(struct methodsig *s1, struct methodsig *s2)
{
	struct formparlist *p1, *p2;

	if (strcmp(s1->name, s2->name)!=0)
		return 0;

	for (p1=s1->params, p2=s2->params; p1 && p2; p1=p1->rest, p2=p2->rest)
		if (!equaltypes(p1->type, p2->type)) return 0;

	if (p1==0 && p2==0)
		return 1;

	return 0;
}

static int booleanmaxdepth=0;
static int bytemaxdepth=0;
static int shortmaxdepth=0;
static int intmaxdepth=0;
static int longmaxdepth=0;
static int charmaxdepth=0;
static int floatmaxdepth=0;
static int doublemaxdepth=0;

void
noteprimtype(enum typeid type, int dims)
{
	switch (type) {
	case Boolean: if (dims>booleanmaxdepth) booleanmaxdepth=dims; break;
	case Byte:    if (dims>bytemaxdepth)    bytemaxdepth=dims;    break;
	case Short:   if (dims>shortmaxdepth)   shortmaxdepth=dims;   break;
	case Int:     if (dims>intmaxdepth)     intmaxdepth=dims;     break;
	case Long:    if (dims>longmaxdepth)    longmaxdepth=dims;    break;
	case Char:    if (dims>charmaxdepth)    charmaxdepth=dims;    break;
	case Float:   if (dims>floatmaxdepth)   floatmaxdepth=dims;   break;
	case Double:  if (dims>doublemaxdepth)  doublemaxdepth=dims;  break;
	case Ref: case Null: case Void: thiscanthappen;
	}
}

int
getprimtypedepth(enum typeid type)
{
	switch (type) {
	case Boolean: return booleanmaxdepth;
	case Byte:    return bytemaxdepth;
	case Short:   return shortmaxdepth;
	case Int:     return intmaxdepth;
	case Long:    return longmaxdepth;
	case Char:    return charmaxdepth;
	case Float:   return floatmaxdepth;
	case Double:  return doublemaxdepth;
	case Ref: case Null: case Void: thiscanthappen;
	}
	return 0;
}

struct name *newname(struct name *prefix,
	const char *id,
	int data,
	struct name *rest)
{
	struct name *new=(struct name *) xmalloc(sizeof(struct name));
	new->prefix=prefix;
	new->id=id;
	new->data=data;
	new->rest=rest;
	return new;
}

struct type *newtype(int dims,
	enum typeid prim,
	struct name *ref)
{
	struct type *new=(struct type *) xmalloc(sizeof(struct type));
	new->dims=dims;
	new->prim=prim;
	new->ref=ref;
	return new;
}

struct typedecl *newtypedecl(u2 modifiers,
	struct name *name,
	struct name *typeimports,
	struct name *typesearchpath,
	struct name *super,
	struct name *implements,
	int arrdepth,
	struct memberdecl *body,
	struct typedecl *rest)
{
	struct typedecl *new=(struct typedecl *) xmalloc(sizeof(struct typedecl));
	new->modifiers=modifiers;
	new->name=name;
	new->typeimports=typeimports;
	new->typesearchpath=typesearchpath;
	new->super=super;
	new->implements=implements;
	new->arrdepth=arrdepth;
	new->body=body;
	new->rest=rest;
	return new;
}

struct memberdecl *newmemberdecl(enum membertag tag,
	union member content,
	struct memberdecl *rest)
{
	struct memberdecl *new=(struct memberdecl *) xmalloc(sizeof(struct memberdecl));
	new->tag=tag;
	new->content=content;
	new->rest=rest;
	return new;
}

struct fielddecl *newfielddecl(u2 modifiers,
	struct type *type,
	struct vardecl *decls)
{
	struct fielddecl *new=(struct fielddecl *) xmalloc(sizeof(struct fielddecl));
	new->modifiers=modifiers;
	new->type=type;
	new->decls=decls;
	return new;
}

struct vardecl *newvardecl(char *name,
	int adddepth,
	struct expr *init,
	struct vardecl *rest)
{
	struct vardecl *new=(struct vardecl *) xmalloc(sizeof(struct vardecl));
	new->name=name;
	new->adddepth=adddepth;
	new->init=init;
	new->rest=rest;
	return new;
}

struct methoddecl *newmethoddecl(u2 modifiers,
	struct type *type,
	struct methodsig *sig,
	struct name *throws,
	struct name *overrides,
	struct stmt *body)
{
	struct methoddecl *new=(struct methoddecl *) xmalloc(sizeof(struct methoddecl));
	new->modifiers=modifiers;
	new->type=type;
	new->sig=sig;
	new->throws=throws;
	new->overrides=overrides;
	new->body=body;
	return new;
}

struct methodsig *newmethodsig(char *name,
	struct formparlist *params)
{
	struct methodsig *new=(struct methodsig *) xmalloc(sizeof(struct methodsig));
	new->name=name;
	new->params=params;
	return new;
}

struct formparlist *newformparlist(struct type *type,
	char *name,
	struct formparlist *rest)
{
	struct formparlist *new=(struct formparlist *) xmalloc(sizeof(struct formparlist));
	new->type=type;
	new->name=name;
	new->rest=rest;
	return new;
}

struct constrdecl *newconstrdecl(u2 modifiers,
	struct methodsig *sig,
	struct name *throws,
	struct constinv *cons,
	struct stmt *body)
{
	struct constrdecl *new=(struct constrdecl *) xmalloc(sizeof(struct constrdecl));
	new->modifiers=modifiers;
	new->sig=sig;
	new->throws=throws;
	new->cons=cons;
	new->body=body;
	return new;
}

struct constinv *newconstinv(char super,
	struct expr *arglist)
{
	struct constinv *new=(struct constinv *) xmalloc(sizeof(struct constinv));
	new->super=super;
	new->arglist=arglist;
	return new;
}

struct stmt *newstmt(enum stmttype tag,
	struct fielddecl *var,
	struct expr *expr,
	struct stmt *stmt1,
	struct stmt *stmt2,
	struct stmt *stmt3,
	struct stmt *stmt4,
	struct catchclause *catch,
	struct stmt *rest)
{
	struct stmt *new=(struct stmt *) xmalloc(sizeof(struct stmt));
	new->tag=tag;
	new->var=var;
	new->expr=expr;
	new->stmt1=stmt1;
	new->stmt2=stmt2;
	new->stmt3=stmt3;
	new->stmt4=stmt4;
	new->catch=catch;
	new->rest=rest;
	return new;
}

struct catchclause *newcatchclause(struct formparlist *param,
	struct stmt *block,
	struct catchclause *rest)
{
	struct catchclause *new=(struct catchclause *) xmalloc(sizeof(struct catchclause));
	new->param=param;
	new->block=block;
	new->rest=rest;
	return new;
}

struct expr *newexpr(enum exprtype tag,
	struct expr *exp1,
	struct expr *exp2,
	struct expr *exp3,
	struct type *type,
	struct name *name,
	s8 integ,
	const char *str,
	struct expr *rest)
{
	struct expr *new=(struct expr *) xmalloc(sizeof(struct expr));
	new->tag=tag;
	new->exp1=exp1;
	new->exp2=exp2;
	new->exp3=exp3;
	new->type=type;
	new->name=name;
	new->integ=integ;
	new->str=str;
	new->rest=rest;
	return new;
}

#endif /* SEEN_parsetree_h */
