
#include "verifier.h"

/*
 * Parse the configuration from the given filename if not NULL or stdin
 * otherwise.
 * returns:
 *  0 on success
 *  1 on failure
 */
int
verify_load_configuration(const char *filename) {
    int result = 1;

	/* REQUIRE(config_initialized); */

	ns_debug(ns_log_config, 3, "load configuration %s", filename);

	loading = 1;

	/*
	 * Clean up any previous configuration and initialize
	 * global data structures we'll be updating.
	 */
    /*
	free_nameserver_info();
	free_secretkey_info();

	bogus_nameservers = new_ip_match_list();
    */

	result = verify_parse_configuration(filename);

    /* use_default_logging is called via init_logging in main */
    /* use_default_options is called via init_configuration in vns_init */

    initial_configuration = 0;
	loading = 0;
	/* release queued notifies */
	return (result);
}

/*
 * Short circuit all logging channels to set them all to stderr.
 */
void
add_log_channel(log_config log_cfg, int category, log_channel chan) {
	if (!log_category_is_active(log_cfg->log_ctx, category))
			_add_log_channel(log_cfg, category, stderr_channel);
}
	
