<?php
# This file is part of BBClone (The PHP web counter on steroids)

# $Header: /cvs/bbclone/redir.php,v 1.10 2005/02/21 00:31:16 olliver Exp $

# Copyright (C) 2001-2004, the BBClone Team (see file doc/authors.txt
# distributed with this library)

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# See doc/copying.txt for details

class bbc_redir {
  # remove unwanted stuff from user input
  function clean($input) {
    $input = str_replace("\\", "/", strip_tags($input));
    $input = trim(str_replace("$", "&#36;", $input));

    return substr($input, 0, 512);
  }

  # set the path for a bounce back
  function get_path($uri, $file) {
    $path = substr($uri, 1);
    $path = "/".substr($path, 0, strrpos($path, "/"));

    return (($path == "/") ? "/" : dirname(strstr($file, $path))."/");
  }

  # find out where bbclone is running on
  function get_srv() {
    $pc_rem = !empty($_SERVER['HTTP_PC_REMOTE_ADDR']) ? true :
              (!empty($GLOBALS['HTTP_SERVER_VARS']['HTTP_PC_REMOTE_ADDR']) ? true : false);
    $is_mac = (stristr(PHP_OS, "darwin") && $pc_rem) ? true : false;

    $host = !empty($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] :
            (!empty($GLOBALS['HTTP_SERVER_VARS']['HTTP_HOST']) ? $GLOBALS['HTTP_SERVER_VARS']['HTTP_HOST'] : false);
    $name = !empty($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] :
            (!empty($GLOBALS['HTTP_SERVER_VARS']['SERVER_NAME']) ? $GLOBALS['HTTP_SERVER_VARS']['SERVER_NAME'] :
             false);
    $addr = ($is_mac && !empty($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] :
             (($is_mac && !empty($GLOBALS['HTTP_SERVER_VARS']['REMOTE_ADDR'])) ?
              $GLOBALS['HTTP_SERVER_VARS']['REMOTE_ADDR'] : false);
    $addr = (!$addr && !empty($_SERVER['SERVER_ADDR'])) ? $_SERVER['SERVER_ADDR'] :
             ((!$addr && !empty($GLOBALS['HTTP_SERVER_VARS']['SERVER_ADDR'])) ?
              $GLOBALS['HTTP_SERVER_VARS']['SERVER_ADDR'] : $addr);
    $addr = (!$addr && !empty($_SERVER['LOCAL_ADDR'])) ? $_SERVER['LOCAL_ADDR'] :
             ((!$addr && !empty($GLOBALS['HTTP_SERVER_VARS']['LOCAL_ADDR'])) ?
              $GLOBALS['HTTP_SERVER_VARS']['LOCAL_ADDR'] : $addr);

    return ($host ? $host : ($name ? $name : ($addr ? $addr : "127.0.0.1")));
  }

  # get the request and find out whether it's valid
  function forward_url() {
    $fwd_url = !empty($_GET['rd']) ? $_GET['rd'] :
               (!empty($GLOBALS['HTTP_GET_VARS']['rd']) ? $GLOBALS['HTTP_GET_VARS']['rd'] : false);
    $fwd_url = $fwd_url ? rawurldecode($fwd_url) : $fwd_url;

    return ($fwd_url ? "http://".$this->clean($fwd_url) : false);
  }

  # check for a local referrer to prevent abuse
  function local_refer($ref) {
    if (empty($ref)) return false;

    $ref_array = parse_url($ref);

    if (($ref_array['host'] == $this->srv) || ((substr($this->srv, 0, 4) == "www.") &&
        (substr($this->srv, 4) == $ref_array['host'])) || ((substr($ref_array['host'], 0, 4) == "www.") &&
        (substr($ref_array['host'], 4) == $this->srv))) {
      return true;
    }
    return false;
  }

  # html code used for the redirect
  function html_output() {
    if ($this->fwd_url && $this->local_refer($this->ref)) {
      return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
            ."<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" "
            ."\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"
            ."<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
            ."<head>\n"
            ."<title>Redirecting...</title>\n"
            ."<meta http-equiv=\"Pragma\" content=\"no-cache\" />\n"
            ."<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n"
            ."<meta http-equiv=\"Refresh\" content=\"0; URL=".$this->fwd_url."\" />\n"
            ."</head>\n"
            ."<body>\n"
            ."</body>\n"
            ."</html>\n";
    }
    return false;
  }

  # constructor
  function bbc_redir() {
    $this->uri = !empty($_SERVER['PHP_SELF']) ? $this->clean($_SERVER['PHP_SELF']) :
                 $this->clean($GLOBALS['HTTP_SERVER_VARS']['PHP_SELF']);
    $this->file = $this->clean(__FILE__);
    $this->path = $this->clean($this->get_path($this->uri, $this->file));
    $this->srv = $this->clean($this->get_srv());
    $this->ref = !empty($_SERVER['HTTP_REFERER']) ? $this->clean($_SERVER['HTTP_REFERER']) :
                 (empty($GLOBALS['HTTP_SERVER_VARS']['HTTP_REFERER']) ? false :
                  $this->clean($GLOBALS['HTTP_SERVER_VARS']['HTTP_REFERER']));
    $this->fwd_url = $this->forward_url();
    $this->bwd_url = "http://".$this->srv.(($this->srv == "127.0.0.1") ? "/" : $this->path);
  }
}
# launching the class
$bbc_redir =& new bbc_redir;

if ($i = $bbc_redir->html_output()) print($i);
else header("Location: ".$bbc_redir->bwd_url);
?>