#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test archive creation
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

initial_setup

test_class "Simple Archive creation"

begin_test "Archive creation 1"
tla make-archive jane@example.com--2003 cached:$(pwd)/test-archive
test "$(tla whereis-archive jane@example.com--2003)" = cached:$(pwd)/test-archive
test -d test-archive/=meta-info
test "Bazaar archive format 1 0" = "$(< test-archive/.archive-version )"
end_test 

begin_test "Archive creation 2 (with listing)"
tla make-archive --listing jane@example.com--2003b $(pwd)/test-archive2
test "$(tla whereis-archive jane@example.com--2003b)" = $(pwd)/test-archive2
dir_exists test-archive2/=meta-info
test -f test-archive2/.listing
test "Bazaar archive format 1 0" = "$(< test-archive2/.archive-version )"
end_test 

begin_test "TLA Archive creation 1"
tla make-archive --tla jane@example.com--2003c $(pwd)/test-archive3
test "$(tla whereis-archive jane@example.com--2003c)" = $(pwd)/test-archive3
test -d test-archive3/=meta-info
test "Hackerlab arch archive directory, format version 2." = "$(< test-archive3/.archive-version )"
end_test 

begin_test "TLA Archive creation 2 (with listing)"
tla make-archive --tla --listing jane@example.com--2003d $(pwd)/test-archive4
test "$(tla whereis-archive jane@example.com--2003d)" = $(pwd)/test-archive4
test -d test-archive4/=meta-info
test -f test-archive4/.listing
test "Hackerlab arch archive directory, format version 2." = "$(< test-archive4/.archive-version )"
end_test 

begin_test "Archive creation 3 (email contains an underscore before @)"
tla make-archive jane_porter@example.com--2004 $(pwd)/test-archive
test "$(tla whereis-archive jane_porter@example.com--2004)" = $(pwd)/test-archive
dir_exists test-archive/=meta-info
end_test 

begin_test "Make an archive with a relative path."
tla register-archive -df foo@example.org
tla make-archive foo@example.org ./foo/
file_matches '^'url=$(pwd)/foo $HOME"/.arch-params/archives/foo@example.org"
end_test

begin_test "Make an archive in a crackful directory."
tla make-archive apt@packages.debian.org--apt apt@packages.debian.org--apt
end_test

begin_test "Make an archive in a crackful directory with brackets (old-style)."
location=`pwd`/\(foo_old\)
name=location_has_brackets_old@example.org
rm -f ~/.arch-params/archives/$name
mkdir ~/.arch-params/=locations
echo "${CACHEDARCHIVEDIR}/$location" > ~/.arch-params/=locations/$name
tla archives | grep $location > /dev/null || test_fail "$location not found in 'baz archives'"
end_test

begin_test "Make an archive in a crackful directory with brackets (new-style)."
location=`pwd`/\(foo_new\)
name=location_has_brackets_new@example.org
tla make-archive $name $location
tla archives | grep $location || test_fail "$location not found in 'baz archives'"
end_test

clean_workdir

# tag: Colin Walters Tue, 16 Sep 2003 22:31:21 -0400 (test-archive-creation.sh)
#
