/* unit-patch.c
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/safe-printfmt.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/patch.h"



/* typedefs */



/* local methods */
/* FIXME: move to hackerlab ? */
static void 
check_patch_init_finalise (void)
{
  arch_patch_t aPatch;
  arch_patch_init (&aPatch, "foo@example.com/foo--bar--0--base-0");
  invariant_str_cmp (arch_patch_id_patch_id(arch_patch_patch_id(&aPatch)), "foo@example.com/foo--bar--0--base-0");
  invariant (!aPatch.creator);
  
  arch_patch_finalise (&aPatch);
  invariant (!arch_patch_patch_id(&aPatch)->patch_id);
}

static void
check_creator(void)
{
  arch_patch_t aPatch;
  arch_patch_init (&aPatch, "foo@example.com/foo--bar--0--base-0");
  invariant (!aPatch.creator);
  arch_patch_creator_set (&aPatch, "john foo");
  invariant (!!aPatch.creator);
  invariant_str_cmp (arch_patch_creator (&aPatch), "john foo");
  
  arch_patch_finalise (&aPatch);
  invariant (!aPatch.creator);
}

static void
check_patch_new_delete (void)
{
  arch_patch_t *aPatch;
  aPatch = arch_patch_new ("foo@example.com/foo--bar--0--base-0");
  invariant_str_cmp (arch_patch_id_patch_id(arch_patch_patch_id(aPatch)), "foo@example.com/foo--bar--0--base-0");
  arch_patch_delete (&aPatch);
  invariant (!aPatch);
  /* test free of NULL */
  arch_patch_delete (&aPatch);
  invariant (!aPatch);
}

static void
check_copy (void)
{
  arch_patch_t aPatch;
  arch_patch_t *newPatch;
  arch_patch_init (&aPatch, "foo@example.com/foo--bar--0--base-0");
  arch_patch_creator_set (&aPatch, "foo");
  invariant_str_cmp (arch_patch_id_patch_id(arch_patch_patch_id(&aPatch)), "foo@example.com/foo--bar--0--base-0");
  invariant_str_cmp (arch_patch_creator (&aPatch), "foo");
  newPatch = arch_patch_copy (&aPatch);
  invariant (newPatch != &aPatch);
  invariant (arch_patch_id_patch_id(arch_patch_patch_id(newPatch)) != arch_patch_id_patch_id(arch_patch_patch_id(&aPatch)));
  invariant_str_cmp (arch_patch_id_patch_id(arch_patch_patch_id(newPatch)), "foo@example.com/foo--bar--0--base-0");
  invariant_str_cmp (arch_patch_creator (newPatch), "foo");
  arch_patch_delete (&newPatch);
  arch_patch_finalise (&aPatch);
}

int
main (int argc, char * argv[])
{
  check_patch_init_finalise();
  check_patch_new_delete();
  check_creator();
  check_copy();
  return 0;
}

