/* patch.c:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 *        Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/namespace.h"
#include "libarch/patch.h"

void
arch_patch_init (arch_patch_t *patch, t_uchar const *patch_id)
{
    arch_patch_id_init (&patch->patch_id, patch_id);
    patch->creator = NULL;
}

void 
arch_patch_finalise (arch_patch_t *patch)
{
    arch_patch_id_finalise (&patch->patch_id);
    lim_free (0, patch->creator);
    patch->creator = NULL;
}

arch_patch_t * 
arch_patch_new (t_uchar const *patch_id)
{
    arch_patch_t *result = lim_malloc (0, sizeof (arch_patch_t));
    arch_patch_init (result, patch_id);
    return result;
}

void
arch_patch_delete (arch_patch_t **patch)
{
    if (!*patch)
        return;
    arch_patch_finalise (*patch);
    lim_free (0, *patch);
    *patch = NULL;
}

arch_patch_t *
arch_patch_copy (arch_patch_t *patch)
{
    arch_patch_t *result = arch_patch_new (arch_patch_id_patch_id(&patch->patch_id));
    if (patch->creator)
        arch_patch_creator_set(result, patch->creator);
    return result;
}

arch_patch_id *
arch_patch_patch_id (arch_patch_t *patch)
{
    return &patch->patch_id;
}

t_uchar *
arch_patch_creator (arch_patch_t *patch)
{
    return patch->creator;
}

void
arch_patch_creator_set (arch_patch_t *patch, t_uchar const *creator)
{
    invariant (!patch->creator);
    patch->creator = str_save (0, creator);
}
