#!/bin/bash
# -*- shell-script -*-

# Test that we are saving and restoring POSIX variables IFS and PS4 that
# the debugger changes.
test_save_restore_IFS_PS4()
{
    typeset  _Dbg_space_IFS=' '
    typeset old_IFS="$IFS"
    typeset new_ifs=' 	'
    IFS="$new_ifs"
    PS4='123'
    _Dbg_set_debugger_entry
    assertEquals "$_Dbg_space_IFS" "$IFS"
    assertNotEquals '123' "$PS4"
    _Dbg_set_to_return_from_debugger 0
    assertNotEquals "$_Dbg_space_IFS" "$IFS"
    assertEquals "$new_ifs" "$IFS"
    IFS="$old_IFS"
}

abs_top_srcdir=/src/external-vcs/bashdb
srcdir=.

_Dbg_libdir=$abs_top_srcdir
set -- -q  # Don't need to show banner
. ${abs_top_srcdir}/dbg-pre.sh
. ${abs_top_srcdir}/lib/journal.sh
. ${abs_top_srcdir}/lib/fns.sh
. ${abs_top_srcdir}/lib/file.sh
. ${abs_top_srcdir}/lib/save-restore.sh

# load shunit2
srcdir=.
srcdir=${srcdir}/
. ${srcdir}/shunit2
