#!/bin/bash
# -*- shell-script -*-

do_test() 
{
    file1=$(_Dbg_expand_filename $1)
    assertTrue 'Should not have an error expanding $1' "$?"
    file2=$(_Dbg_expand_filename $2)
    assertEquals "$file1" "$file2"

}
test_expand_filename()
{
    do_test test-pre ./test-pre
    do_test "$PWD/" "${PWD}/."
    do_test /tmp /tmp
    file1=$(echo ~)
    do_test "$file1" ~
}

test_do_show_version()
{
    # Name we refer to ourselves by
    typeset _Dbg_debugger_name='bashdb'
    # The release name we are configured to run under.
    typeset _Dbg_release='4.0-0.4'

    version_string=$(_Dbg_do_show_version)
    assertEquals "bashdb, release 4.0-0.4" "$version_string"
}
abs_top_srcdir=/src/external-vcs/bashdb

_Dbg_libdir=$abs_top_srcdir
set -- -q  # Don't need to show banner

. ${abs_top_srcdir}/dbg-pre.sh

# load shunit2
. ${abs_top_srcdir}/test/unit/shunit2

