#include <stdio.h>
#include <pthread.h>
#include "forms.h"
#include "rtty_f.h"
#include "common.h"

extern void adj_baudp(int dr);

FD_rtty_form *fd_rtty_form;

void form_main()
{
   pthread_t pth;
   int argc=1;
   const char *argv[]={"rtty"};
   char buf[80];

   fl_initialize(&argc, argv, 0, 0, 0);
   fd_rtty_form = create_form_rtty_form();

   /* fill-in form initialization code */
   if (fskdp->nbit==5) fl_set_button(fd_rtty_form->sd5, 1);
   if (fskdp->nbit==7) fl_set_button(fd_rtty_form->sd7, 1);
   if (fskdp->nbit==8) fl_set_button(fd_rtty_form->sd8, 1);

   if (fskdp->nstop==1) fl_set_button(fd_rtty_form->ssb1, 1);
   if (fskdp->nstop==2) fl_set_button(fd_rtty_form->ssb2, 1);

   if (fskdp->parity==0) fl_set_button(fd_rtty_form->sp0, 1);
   if (fskdp->parity==1) fl_set_button(fd_rtty_form->sp1, 1);
   if (fskdp->parity==2) fl_set_button(fd_rtty_form->sp2, 1);

   sprintf(buf,"%d",fskdp->dr);
   fl_set_input(fd_rtty_form->sbaud, buf);
   adj_baudp(fskdp->dr);
   fl_set_counter_value(fd_rtty_form->sspace, fskdp->spacef);
   fl_set_counter_value(fd_rtty_form->smark, fskdp->markf);

   /* show the first form */
   fl_show_form(fd_rtty_form->rtty_form,FL_PLACE_SIZE,FL_FULLBORDER,"rtty_form");

   pthread_create(&pth, NULL, graph_main , NULL);

   fl_do_forms();

}
