/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import sun.tools.native2ascii.Main;

public class Native2Ascii
extends MatchingTask {
    private boolean reverse = false;
    private String encoding = null;
    private File srcDir = null;
    private File destDir = null;
    private String extension = null;

    private void convert(String fileName) throws BuildException {
        Commandline cmd = new Commandline();
        if (this.reverse) {
            cmd.createArgument().setValue("-reverse");
        }
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        File srcFile = new File(this.srcDir, fileName);
        File destFile = this.extension != null ? new File(this.destDir, String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + this.extension) : new File(this.destDir, fileName);
        cmd.createArgument().setFile(srcFile);
        cmd.createArgument().setFile(destFile);
        if (!destFile.exists() || destFile.lastModified() < srcFile.lastModified()) {
            File parentFile;
            if (srcFile.equals(destFile)) {
                throw new BuildException("file " + srcFile + " would overwrite its self");
            }
            String parentName = destFile.getParent();
            if (parentName != null && !(parentFile = new File(parentName)).exists() && !parentFile.mkdirs()) {
                throw new BuildException("cannot create parent directory " + parentName);
            }
            this.log("converting " + fileName, 3);
            Main n2a = new Main();
            if (!n2a.convert(cmd.getArguments())) {
                throw new BuildException("conversion failed");
            }
        }
    }

    public void execute() throws BuildException {
        Object baseCmd = null;
        DirectoryScanner scanner = null;
        if (this.srcDir == null) {
            this.srcDir = this.project.resolveFile(".");
        }
        if (this.destDir == null) {
            throw new BuildException("The dest attribute must be set.");
        }
        if (this.srcDir.equals(this.destDir) && this.extension == null) {
            throw new BuildException("The ext attribut must be set if src and dest dirs are the same.");
        }
        scanner = this.getDirectoryScanner(this.srcDir);
        this.log("Converting files from " + this.srcDir + " to " + this.destDir);
        String[] files = scanner.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            this.convert(files[i]);
            ++i;
        }
    }

    public void setDest(File destDir) {
        this.destDir = destDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExt(String ext) {
        this.extension = ext;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setSrc(File srcDir) {
        this.srcDir = srcDir;
    }
}

