/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.util.cache.LruCache;
import java.util.Properties;

public class DbsCache
extends LruCache {
    private boolean keepStats;
    private int hits = 0;
    private int misses = 0;

    public DbsCache(Properties properties) {
        super(ParseinfoCache.getSizeProperty(properties));
        this.setOptions(properties);
    }

    private void setOptions(Properties properties) {
        String string = properties.getProperty("cache");
        this.keepStats = string.indexOf(63) >= 0;
    }

    public void use(String string) {
        Object object = this.get(string);
        if (object != null) {
            ++this.hits;
        } else {
            ++this.misses;
            this.put(string, string);
        }
    }

    protected void dumpStats() {
        if (!this.keepStats) {
            return;
        }
        System.out.println("Dbs cache statistics:");
        System.out.println(this.hits + " hits");
        System.out.println(this.misses + " misses");
        System.out.println("---------------------------------------------");
    }
}

