package com.icl.saxon.om;

/**
  * An object representing the collection of documents handled during
  * a single transformation
  * @author <A HREF="mailto:mhkay@iclway.co.uk>Michael H. Kay</A> 
  */

public final class DocumentPool {

    private DocumentInfo[] documents = new DocumentInfo[10];
    private String[] documentNames = new String[10];
    private int numberOfDocuments = 0;
    
    /**
    * Add a document to the pool, and allocate a document number
    * @param doc The DocumentInfo for the document in question
    * @param name The name of the document. May be null, in the case of
    * the principal source document.
    * @return the document number, unique within this document pool
    */
    
    public int add(DocumentInfo doc, String name) {
        
        int existing = getDocumentNumber(doc);
        if (existing>=0) return existing;
        
        if (numberOfDocuments == documents.length) {
            DocumentInfo[] docs2 = new DocumentInfo[numberOfDocuments*2];
            System.arraycopy(documents, 0, docs2, 0, numberOfDocuments);
            documents = docs2;
            String[] names2 = new String[numberOfDocuments*2];
            System.arraycopy(documentNames, 0, names2, 0, numberOfDocuments);
            documentNames = names2;

        }
        if (numberOfDocuments==65535) {
            throw new UnsupportedOperationException("Too many documents in one transformation: limit is 65535");
        }
        int n = numberOfDocuments++;
        documents[n] = doc;
        documentNames[n] = name;
        return n;
    }

    /**
    * Get the document number of a document that is already in the pool
    * @return the document number, or -1 if it is not found in the pool
    */
    
    public int getDocumentNumber(DocumentInfo doc) {
        for (int n=0; n<numberOfDocuments; n++) {
            if (documents[n]==doc) return n;
        }
        return -1;
    }
    
    /**
    * Get the document with a given name
    * @return the DocumentInfo with the given name if it exists,
    * or null if it is not found.
    */
    
    public DocumentInfo find(String name) {
        for (int n=0; n<numberOfDocuments; n++) {
            if (name.equals(documentNames[n])) {
                return documents[n];
            }
        }
        return null;
    }

    /**
    * Get the number of documents in the pool
    */
    
    public int getNumberOfDocuments() {
        return numberOfDocuments;
    }
        
}

//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/ 
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License. 
//
// The Original Code is: all this file. 
//
// The Initial Developer of the Original Code is
// Michael Kay of International Computers Limited (mhkay@iclway.co.uk).
//
// Portions created by (your name) are Copyright (C) (your legal entity). All Rights Reserved. 
//
// Contributor(s): none. 
//
