---
comments: false
---

# From 5.1 to 6.0
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/5.1-to-6.0.md) for the most up to date instructions.*

## Warning

GitLab 6.0 is affected by critical security vulnerabilities CVE-2013-4490 and CVE-2013-4489.

## Deprecations

### Global projects

The root (global) namespace for projects is deprecated.

So you need to move all your global projects under groups or users manually before update or they will be automatically moved to the project owner namespace during the update. When a project is moved all its members will receive an email with instructions how to update their git remote URL. Please make sure you disable sending email when you do a test of the upgrade.

### Teams

We introduce group membership in 6.0 as a replacement for teams.

The old combination of groups and teams was confusing for a lot of people.

And when the members of a team where changed this wasn't reflected in the project permissions.

In GitLab 6.0 you will be able to add members to a group with a permission level for each member.

These group members will have access to the projects in that group.

Any changes to group members will immediately be reflected in the project permissions.

You can even have multiple owners for a group, greatly simplifying administration.

## 0. Backup & prepare for update

It's useful to make a backup just in case things go south:
(With MySQL, this may require granting "LOCK TABLES" privileges to the GitLab user on the database version)

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

The migrations in this update are very sensitive to incomplete or inconsistent data. If you have a long-running GitLab installation and some of the previous upgrades did not work out 100% correct this may bite you now. The following can help you have a more smooth upgrade.

### Find projects with invalid project names

#### MySQL
Login to MySQL:

    mysql -u root -p

Find projects with invalid names:

```bash
mysql> use gitlabhq_production;

# find projects with invalid first char, projects must start with letter
mysql> select name from projects where name REGEXP '^[^A-Za-z]';

# find projects with other invalid chars
## names must only contain alphanumeric chars, underscores, spaces, periods, and dashes
mysql> select name from projects where name REGEXP '[^a-zA-Z0-9_ .-]+';
```

If any projects have invalid names try correcting them from the web interface before starting the upgrade.
If correcting them from the web interface fails you can correct them using MySQL:

```bash
# e.g. replace invalid / with allowed _
mysql> update projects set name = REPLACE(name,'/','_');
# repeat for all invalid chars found in project names
```

#### PostgreSQL
Make sure all project names start with a letter and only contain alphanumeric chars, underscores, spaces, periods, and dashes (a-zA-Z0-9_ .-).

### Find other common errors

```
cd /home/git/gitlab
# Start rails console
sudo -u git -H bin/rails console production

# Make sure none of the following rails commands return results

# All project owners should have an owner:
Project.all.select { |project| project.owner.blank? }

# Every user should have a namespace:
User.all.select { |u| u.namespace.blank? }

# Projects in the global namespace should not conflict with projects in the owner namespace:
Project.where(namespace_id: nil).select { |p| Project.where(path: p.path, namespace_id: p.owner.try(:namespace).try(:id)).present? }
```

If any of the above rails commands returned results other than `=> []` try correcting the issue from the web interface.

If you find projects without an owner (first rails command above), correct it. For MySQL setups:

```bash
# get your user id
mysql> select id, name from users order by name;

# set yourself as owner of project
# replace your_user_id with your user id and bad_project_id with the project id from the rails command
mysql> update projects set creator_id=your_user_id where id=bad_project_id;
```

## 1. Stop server

    sudo service gitlab stop

## 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch
sudo -u git -H git checkout 6-0-stable
```

## 3. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.7.9
```

## 4. Install additional packages

```bash
# For reStructuredText markup language support install required package:
sudo apt-get install python-docutils
```

## 5. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u git -H vim Gemfile

# MySQL

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test postgres --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test mysql --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test mysql --deployment

# Both MySQL and PostgreSQL
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_groups RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_global_projects RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_keys RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_inline_notes RAILS_ENV=production
sudo -u git -H bundle exec rake gitlab:satellites:create RAILS_ENV=production

# Clear redis cache
sudo -u git -H bundle exec rake cache:clear RAILS_ENV=production

# Clear and precompile assets
sudo -u git -H bundle exec rake assets:clean RAILS_ENV=production
sudo -u git -H bundle exec rake assets:precompile RAILS_ENV=production

#Add dealing with newlines for editor
sudo -u git -H git config --global core.autocrlf input
```

## 6. Update config files

Note: We switched from Puma in GitLab 5.x to unicorn in GitLab 6.0.

- Make `/home/git/gitlab/config/gitlab.yml` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/6-0-stable/config/gitlab.yml.example but with your settings.
- Make `/home/git/gitlab/config/unicorn.rb` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/6-0-stable/config/unicorn.rb.example but with your settings.

## 7. Update Init script

```bash
cd /home/git/gitlab
sudo rm /etc/init.d/gitlab
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
sudo chmod +x /etc/init.d/gitlab
```

## 8. Create uploads directory

```bash
cd /home/git/gitlab
sudo -u git -H mkdir -p public/uploads
sudo chmod -R u+rwX  public/uploads
```

## 9. Start application

    sudo service gitlab start
    sudo service nginx restart

## 10. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade complete!

## Things went south? Revert to previous version (5.1)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 5.0 to 5.1](5.0-to-5.1.md), except for the database migration (the backup is already migrated to the previous version).

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
