
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.ext;

import java.awt.*;
import javax.swing.text.*;

/**
 * A document class used to enter an integer into a text component.
 * The integer may be positive, zero or negative.
 * This class ensures that the input contains only digits and an optional
 * leading minus sign.
 */
public class IntegerDocument extends PlainDocument {
    /**
     * Attempts to insert a string into the document.
     */
    public void insertString(int offs, String str, AttributeSet a)
            throws BadLocationException {
        boolean error = false;
        for (int i=0; i < str.length(); i++)
            if (! Character.isDigit(str.charAt(i)))
                if (offs > 0 || i > 0 || str.charAt(i) != '-') {
                    error = true;
                    break;
                }
        if (! error)
            if (offs == 0 && str.length() > 0)
                if (getText(0, 1).charAt(0) == '-')
                    error = true;

        if (error)
            Toolkit.getDefaultToolkit().beep();
        else
            super.insertString(offs, str, a);
    }

    /**
     * Returns the integer value stored in the document as an <tt>int</tt>.
     *
     * @return the integer stored.
     * @throws EmptyDocumentException thrown if the document is empty
     * (which is possible) or if the integer could not be parsed
     * (which should never be the case).
     */
    public int getIntValue() throws EmptyDocumentException {
        try {
            return Integer.parseInt(getText(0, getLength()));
        } catch (Exception e) {
            throw new EmptyDocumentException();
        }
    }

    /**
     * Returns the integer value stored in the document as a <tt>long</tt>.
     *
     * @return the integer stored.
     * @throws EmptyDocumentException thrown if the document is empty
     * (which is possible) or if the integer could not be parsed
     * (which should never be the case).
     */
    public long getLongValue() throws EmptyDocumentException {
        try {
            return Long.parseLong(getText(0, getLength()));
        } catch (Exception e) {
            throw new EmptyDocumentException();
        }
    }
}
