.TH ATARI800 1 "April 04, 2011"

.SH NAME
atari800 \- Atari 800 Emulator, Version 2.2.1

.SH SYNOPSIS
\fBatari800\fP [options] [files...]

.SH DESCRIPTION
\fIatari800\fP emulates the Atari 800, Atari 800 XL, Atari 130 XE and
Atari 5200 Games System.

.SS Options

.TP
\fB-help
Print complete and up-to-date list of command line switches
.TP
\fB-v
Print emulator version
.TP
\fB-verbose
Display framerate when exiting
.TP
\fB-config filename
Specify an alternative configuration filename

.TP
\fB-osa_rom filename
Path to file containing Atari Rev.A Operating System.
Used to override paths defined at compile time.
.TP
\fB-osb_rom filename
Path to file containing Atari Rev.B Operating System.
Used to override paths defined at compile time.
.TP
\fB-xlxe_rom filename
Path to file containing Atari XL/XE Operating System.
Used to override paths defined at compile time.
.TP
\fB-5200_rom filename
Path to file containing Atari 5200 Games System ROM.
Used to override paths defined at compile time.
.TP
\fB-basic_rom filename
Path to file containing Atari BASIC ROM.
Used to override paths defined at compile time.

.TP
\fB-atari
Emulate Atari 800
.TP
\fB-xl
Emulate Atari 800 XL
.TP
\fB-xe
Emulate Atari 130 XE
.TP
\fB-320xe
Emulate Atari 320 XE (Compy Shop)
.TP
\fB-rambo
Emulate Atari 320 XE (Rambo)
.TP
\fB-5200
Emulate Atari 5200
.TP
\fB-emuos
Use EmuOS

.TP
\fB-a
Use Atari OS/A for Atari 800
.TP
\fB-b
Use Atari OS/B for Atari 800
.TP
\fB-c
Enable RAM between 0xc000 and 0xcfff in Atari 800

.TP
\fB-axlon <n>
Use Atari 800 Axlon memory expansion: <n> k total RAM
.TP
\fB-axlon0f
Use Axlon shadow at 0x0fc0-0x0fff
.TP
\fB-mosaic <n>
Use 400/800 Mosaic memory expansion: <n> k total RAM

.TP
\fB-pal
Emulate PAL TV mode
.TP
\fB-ntsc
Emulate NTSC TV mode

.TP
\fB-nobasic
Used to disable Basic when starting the emulator in XL/XE mode.
Simulates the Option key being held down during system boot.
.TP
\fB-basic
Turn on Atari BASIC ROM

.TP
\fB-cart <filename>
Insert cartridge (CART or raw format)
.TP
\fB-run <filename>
Run Atari program (EXE, COM, XEX, BAS, LST)
.TP
\fB-state <filename>
Load saved-state file
.TP
\fB-tape <filename>
Attach cassette image (CAS format or raw file)
.TP
\fB-boottape <filename>
Attach cassette image and boot it

.TP
\fB-1400
Emulate the Atari 1400XL
.TP
\fB-xld
Emulate the Atari 1450XLD
.TP
\fB-bb
Emulate the CSS Black Box
.TP
\fB-mio
Emulate the ICD MIO board

.TP
\fB-nopatch
Normally the OS is patched giving very fast I/O. This options prevents
the patch from being applied so that the OS accesses the serial port
hardware directly. This option will probably never be needed since
programs that access the serial hardware should work even if the OS
has been patched.
.TP
\fB-nopatchall
Don't patch OS at all, H:, P: and R: devices won't work

.TP
\fB-H1 <path>
Set path for H1: device
.TP
\fB-H2 <path>
Set path for H2: device
.TP
\fB-H3 <path>
Set path for H3: device
.TP
\fB-H4 <path>
Set path for H4: device
.TP
\fB-Hpath <path>
Set path for Atari executables on the H: device
.TP
\fB-hreadonly
Enable read-only mode for H: device
.TP
\fB-hreadwrite
Disable read-only mode for H: device
.TP
\fB-devbug
Put debugging messages for H: and P: devices in log file

.TP
\fB-rtime
Enable R-Time 8 emulation
.TP
\fB-nortime
Disable R-Time 8 emulation

.TP
\fBrdevice [<dev>]
Enable R: device. If <dev> is specified then it's used as host serial device
name (e.g. /dev/ttyS0 on linux). If there is no <dev> specified then R:
is directed to network.

.TP
\fB-mouse off
Do not use mouse
.TP
\fB-mouse pad
Emulate paddles
.TP
\fB-mouse touch
Emulate Atari Touch Tablet
.TP
\fB-mouse koala
Emulate Koala Pad
.TP
\fB-mouse pen
Emulate Light Pen
.TP
\fB-mouse gun
Emulate Light Gun
.TP
\fB-mouse amiga
Emulate Amiga mouse
.TP
\fB-mouse st
Emulate Atari ST mouse
.TP
\fB-mouse trak
Emulate Atari Trak-Ball
.TP
\fB-mouse joy
Emulate joystick using mouse
.TP
\fB-mouseport <num>
Set mouse port 1-4 (default 1)
.TP
\fB-mousespeed <num>
Set mouse speed 1-9 (default 3)
.TP
\fB-multijoy
Emulate MultiJoy4 interface
.TP
\fB-directmouse
Use mouse's absolute position
.TP
\fB-cx85 <num>
Emulate CX85 numeric keypad on port <num>
.TP
\fB-grabmouse
SDL only, prevent mouse pointer from leaving the window

.TP
\fB-record <filename>
Record all input events to <filename>. Can be used for gaming contests
(highest score etc).
.TP
\fB-playback <filename>
Playback input events from <filename>. Watch an expert play the game.

.TP
\fB-refresh
Controls screen refresh rate. A numerical value follows this option
which specifies how many emulated screen updates are required before
the actual screen is updated. This value effects the speed of the
emulation: A higher value results in faster CPU emulation but a
less frequently updated screen.

.TP
\fB-artif <mode>
Set artifacting mode 0-4 (0 = disable)

.TP
\fB-colors-preset standard|deep-black|vibrant
Use one of predefined colour adjustments
.TP
\fB-saturation <n>
Set screen color saturation (like TV Colour control)
.TP
\fB-ntsc-saturation <n>\fR, \fB-pal-saturation <n>\fR
Set saturation only for NTSC or PAL, respectively
.TP
\fB-contrast <n>
Set screen contrast (also called white level)
.TP
\fB-ntsc-contrast <n>\fR, \fB-pal-contrast <n>\fR
Set contrast only for NTSC or PAL, respectively
.TP
\fB-brightness <n>
Set screen brightness (also called black level)
.TP
\fB-ntsc-brightness <n>\fR, \fB-pal-brightness <n>\fR
Set brightness only for NTSC or PAL, respectively
.TP
\fB-gamma <n>
Set screen gamma correction
.TP
\fB-ntsc-gamma <n>\fR, \fB-pal-gamma <n>\fR
Set gamma adjustment only for NTSC or PAL, respectively
.TP
\fB-hue <n>
Set hue -1..1 (like TV Tint control). Only for NTSC.
.TP
\fB-colordelay <n>
Set GTIA color delay. This emulates adjusting the potentiometer visible at
the bottom of Atari computers, which adjusts hues of colors produced by
the computer. Only for NTSC.

.TP
\fB-paletten <filename>\fR, \fB-palettep <filename>\fR
Read Atari NTSC/PAL colors from ACT file
.TP
\fB-paletten-adjust\fR, \fB-palettep-adjust\fR
Apply colour adjustments (brightness, contrast etc.) to the loaded NTSC/PAL
palette (by default the loaded palette is displayed unmodified).

.TP
\fB-screenshots <pattern>
Set filename pattern for screenshots. Use to override the default
atari000.png, atari001.png etc. filenames. Hashes are replaced with
raising numbers. Existing files are overwritten only if all the files
defined by the pattern exist.

.TP
\fB-showspeed
Show percentage of actual speed

.TP
\fB-sound
Enable sound
.TP
\fB-nosound
Disable sound
.TP
\fB-dsprate <freq>
Set mixing frequency (Hz)
.TP
\fB-snddelay <time>
Set sound delay (milliseconds)

.SS Curses Options

.TP
\fB-left
Use columns 0 to 39
.TP
\fB-central
Use columns 20 to 59
.TP
\fB-right
Use columns 40 to 79
.TP
\fB-wide1
Use columns 0 to 79. In this mode only the even character positions
are used. The odd locations are filled with spaces.
.TP
\fB-wide2
Use columns 0 to 79. This mode is similar to \fB-wide1\fP except that
the spaces are in reverse video if the previous character was also
in reverse video.

.SS Falcon Options

.TP
\fB-interlace <x>
Generate Falcon screen only every x frame
.TP
\fB-videl
Direct VIDEL programming (Falcon/VGA only)
.TP
\fB-double
Double the screen size on NOVA
.TP
\fB-delta
Delta screen output (differences only)
.TP
\fB-joyswap
Swap joysticks

.SS Java NestedVM

.TP
\fB-scale <n>
Scale width and height by <n>

.SS SDL Options

.TP
\fB-fullscreen
Start in fullscreen mode. The default resolution is 336x240 and can be later
changed.
.TP
\fB-windowed
Start in a window (the default).
.TP
\fB-rotate90
Rotate display (useful for devices with 240x320 screen).
.TP
\fB-no-rotate90
Don't rotate display (the default).
.TP
\fB-fs-width <number-of-pixels>
Host horizontal resolution for fullscreen.
.TP
\fB-fs-height <number-of-pixels>
Host vertical resolution for fullscreen.
.TP
\fB-win-width <number-of-pixels>
Set horizontal size of the window. The window can be later resized manually.
.TP
\fB-win-height <number-of-pixels>
Set vertical size of the window. The window can be later resized nanually.
.TP
\fB-bpp <number-of-bits>
Sets image color depth when OpenGL acceleration is disabled. Accepted values
are: 0 (use desktop depth; this is the default), 8, 16 and 32. Depending on
the type of graphics hardware, the fullscreen setting and current desktop bit
depth, either of the values might give the best performance. Note that with
bit depth set to 16 emulation of colors is slightly less accurate.
.TP
\fB-vsync
Synchronize the display with the monitor's vertical retrace, to remove image
tearing artifacts. This improves display quality, but may be not available
depending on the current wideo mode (fullscreen/windowed), the chosen
SDL_VIDEODRIVER and type of graphics hardware. Synchronization is available
for some SDL videodrivers (directx, dga) but not for others. In OpenGL this
option has no effect - vertical synchronization must be instead enabled in the
video hardware driver's settings, if available.
.TP
\fB-no-vsync
Disable synchronization with monitor's vertical retrace (the default).
.TP
\fB-horiz-area narrow|tv|full|<number>
Set amount of visible screen horizontally. "narrow" shows 320 pixels, "tv"
(the default) shows area visible on a standard TV (336 pixels), and "full"
shows full overscan area (384 pixels). An exact horizontal size can be set by
providing a number between 160 and 384.
.TP
\fB-vertical-area short|tv|full|<number>
Set amount of visible screen vertically. "short" shows 200 pixels, "tv" (the
default) shows area visible on a typical TV (224 or 240 pixels, depending on
current TV system), and "full" shows full overscan area of 275 pixels. An
exact number of visible scanlines can be set by providing a number between 100
and 275. Note that when displaying output of an XEP80 or Austin Franklin 80
column card, the "tv" setting will crop the top and bottom parts of text area,
just like a real TV does - in such case setting the option to "full" would be
more appriopriate.
.TP
\fB-horiz-shift <number>
When the visible horizontal area is not set to "full", this option specifies
the screen's area that will be visible. Values higher than 0 will cause
showing more of the right side of the screen, while values lower than 0 will
cause showing more of the left side. The default is 0 (no shift).
\fB-vert-shift <number>
Analogically to -horiz-shift: when the visible vertical area is not set to
"full", this option specifies the screen's area that will be visible. Values
higher than 0 will cause showing more of the bottom part of the screen, while
values lower than 0 will cause showing more of the top part. The default is 0
(no shift).
.TP
\fB-stretch none|integral|full|<number>
Choose method of stretching the image to fit the screen/window area. "none"
means that the image won't be stretched at all; "integral" (the default)
means that the image will fit the screen/window but will be stretched only by
an integral multiplier. This setting allows for nice output when using
scanlines in low screen resolutions; "full" means that the screen will fit
the entire screen/window area. This setting looks best in high screen
resolutions; A custom multiplier (floating point number) can be also provided
 to precisely set the amount of stretching.
.TP
\fB-fit-screen width|height|both
When -stretch is set to "integral" or "full", this parameter controls how
the stretching is performed with relation to window/screen size. "width" will
fit the image's width while allowing it to be cropped vertically; "height"
will fit the image's height while allowing it to be cropped horizontally;
"both" (the default) will fit both the image's width and height, avoiding
cropping.
.TP
\fB-image-aspect none|square-pixels|real
Choose how the image's aspect ratio should be maintained when stretching.
"none" causes the image to be stretched without restriction to fit the
screen/window area fully; "square-pixels" (the default) causes the image to
be stretched by the same amount horizontally and vertically, maintaining
square pixels. In low screen resolutions this setting may produce the nicest
result; "real" recreates the aspect ratio of a real TV display (pixels are
not square), but only if the -host-aspect-ratio option is set correctly.
.TP
\fB-host-aspect-ratio auto|<x>:<y>
Set the aspect ratio of the host monitor on which the emulator's display is
placed. Allowed values are "auto" for autodetection, or ratios like 4:3, 16:9,
1.25:1 ... This value is used to properly maintain image's aspect ratio when
having -image-aspect set to "real". The default value is "auto".
Note that host aspect ratio detection works as expected only if the desktop
resolution matches aspect ratio of the display device (in other words, display
pixels are square). If, for example, desktop resolution is 800x600 on a 16:9
monitor, autodetection will fail and host aspect ratio will have to be set
manually, by measuring physical width and height of the monitor and setting
the parameter to <width>:<height>.
.TP
\fB-80column
Shows output of an 80 column hardware, when it is available (the default).
This parameter has effect only if an 80 column hardware is activated, using
one of the parameters -af80, -proto80 or -af80.
.TP
\fB-no-80column
Deactivates showing output of an 80 column hardware.


.TP
\fB-audio16
Enable 16-bit sound output

.TP
\fB-nojoystick
Do not initialize SDL joysticks
.TP
\fB-joy0 path-to-device
Define path to device used in LPTjoy 0. Available on linux-ia32 only.
.TP
\fB-joy1 path-to-device
Define path to device used in LPTjoy 1. Available on linux-ia32 only.

.TP
\fB-ntscemu
Activate NTSC filter. This faithfully emulates NTSC composite
video artifacts. "-artif" is not needed in this mode and will not work.
.TP
\fB-no-ntscemu
Disable NTSC filter.
.TP
\fB-ntsc-filter-preset composite|svideo|rgb|monochrome
Use one of predefined NTSC filter adjustments.
.TP
\fB-ntsc-sharpness <n>
Set sharpness of the NTSC filter.
.TP
\fB-ntsc-resolution <n>
Set resolution of the NTSC filter.
.TP
\fB-ntsc-artifacts <n>
Set artifacts of the NTSC filter.
.TP
\fB-ntsc-fringing <n>
Set fringing of the NTSC filter.
.TP
\fB-ntsc-bleed <n>
Set bleed of the NTSC filter.
.TP
\fB-ntsc-burstphase <n>
Set burst phase of the NTSC filter. This changes colors of artifacts. The best
values are 0, 0.5, 1, 1.5.
.TP
\fB-scanlines <n>
Set visibility of scanlines (0..100). Scanlines are only visible when the
screen's or window's vertical size is at least 480 (more precisely, at least
twice the number of scanlines given in -vert-area).
.TP
\fB-scanlinesint
Enable scanlines interpolation (looks nicer).
.TP
\fB-no-scanlinesint
Disable scanlines interpolation (in software modes may give better performance).
.TP
\fB-video-accel
Use OpenGL hardware acceleration for displaying and stretching of the emulator's
display. Using OpenGL improves performance.
.TP
\fB-no-video-accel
Don't use OpenGL hardware acceleration (the default).
.TP
\fB-pixel-format bgr16|rgb16|bgra32|argb32
Choose format of texture data when OpenGL acceleration is enabled. Depending
on the type of the graphics hardware, either of the values might give the best
performance. Note that with pixel format set to bgr16 or rgb16, emulation of
colors is slightly less accurate.
.TP
\fB-pbo
Use Pixel Buffer Objects when OpenGL acceleration is enabled (the default).
PBOs are available on newer graphics hardware and when used, substantially
improve emulator's performance. However in rare cases (some Intel on-board
chips) using PBOs may actually descrease perfromance.
.TP
\fB-no-pbo
Don't use Pixel Buffer Objects when OpenGL acceleration is used.
.TP
\fB-bilinear-filter
Enable bilinear filtering of the screen in OpenGL modes.
.TP
\fB-no-bilinear-filter
Disable bilinear filtering in OpenGL modes (the default).
.TP
\fb-opengl-lib <path>
Provide a custom OpenGL shared library. If not given, Atari800 will use
a default system-specific library (typically opengl32.dll or libGL.so).
.TP
\fB-proto80
Emulate a prototype 80 column board for the 1090
.TP
\fB-xep80
Emulate the XEP80
.TP
\fB-xep80port <n>
Use XEP80 on joystick port <n>
.TP
\fB-af80
Emulate the Austin Franklin 80 column daughterboard for Atari 800.


.SS X11 Options

.TP
\fB-small
Run the emulator in a small window where each Atari 800 pixel is
represented by one X Window pixel
.TP
\fB-large
Runs the emulator in a large window where each Atari 800 pixel is
represented by a 2x2 X Window rectange. This mode is selected by
default.
.TP
\fB-huge
Runs the emulator in a huge window where each Atari 800 pixel is
represented by a 3x3 X Window rectange
.TP
\fB-clip_x number-of-pixels
Set left offset for clipping
.TP
\fB-clip_width number-of-pixels
Set the width of the clipping-area
.TP
\fB-clip_y number-of-pixels
Set top offset for clipping
.TP
\fB-clip_height number-of-pixels
Set the height of the clipping-area
.TP
\fB-private_cmap
Use private colormap
.TP
\fB-sio
Show SIO monitor
.TP
\fB-x11bug
Enable debug code in atari_x11.c

.TP
\fB-keypad
Keypad mode

.PD 0

.SH KEYBOARD, JOYSTICK AND OTHER CONTROLLERS

.TP
\fBF1
Built in user interface
.TP
\fBF2
Option key
.TP
\fBF3
Select key
.TP
\fBF4
Start key
.TP
\fBF5
Reset key ("warm reset")
.TP
\fBShift+F5
Reboot ("cold reset")
.TP
\fBF6
Help key (XL/XE only)
.TP
\fBF7
Break key
.TP
\fBF8
Enter monitor
.TP
\fBF9
Exit emulator
.TP
\fBF10
Save screenshot
.TP
\fBShift+F10
Save interlaced screenshot
.TP
\fBAlt+R
Run Atari program
.TP
\fBAlt+D
Disk management
.TP
\fBAlt+C
Cartridge management
.TP
\fBAlt+Y
Select system
.TP
\fBAlt+O
Sound settings
.TP
\fBAlt+W
Sound recording start/stop
.TP
\fBAlt+S
Save state file
.TP
\fBAlt+L
Load state file
.TP
\fBAlt+A
About the emulator
.TP
\fBInsert
Insert line (Atari Shift+'>')
.TP
\fBCtrl+Insert
Insert character (Atari Ctrl+'>')
.TP
\fBShift+Ctrl+Insert
Shift+Ctrl+'>'
.TP
\fBDelete
Delete line (Atari Shift+Backspace)
.TP
\fBShift+Backspace
Delete line (Atari Shift+Backspace)
.TP
\fBCtrl+Delete
Delete character (Atari Ctrl+Backspace)
.TP
\fBCtrl+Backspace
Delete character (Atari Ctrl+Backspace)
.TP
\fBShift+Ctrl+Delete
Shift+Ctrl+Backspace
.TP
\fBShift+Ctrl+Backspace
Shift+Ctrl+Backspace
.TP
\fBHome
Clear (Atari Shift+'<')
.TP
\fBCtrl+Home
Ctrl+'<' (also clears screen)
.TP
\fBShift+Ctrl+Home
Shift+Ctrl+'<'
.TP
\fB~
Inverse video
.TP
\fBUp
Up (Atari Ctrl+'-')
.TP
\fBDown
Down (Atari Ctrl+'=')
.TP
\fBLeft
Left (Atari ctrl+'+')
.TP
\fBRight
Right (Atari ctrl+'*')
.TP
\fBCtrl+Up
-
.TP
\fBCtrl+Down
=
.TP
\fBCtrl+Left
+
.TP
\fBCtrl+Right
*
.TP
\fBShift+Up
_ (Atari Shift+'-')
.TP
\fBShift+Down
| (Atari Shift+'=')
.TP
\fBShift+Left
\ (Atari Shift+'+')
.TP
\fBShift+Right
^ (Atari Shift+'*')
.TP
\fBShift+Ctrl+Up
Shift+Ctrl+-
.TP
\fBShift+Ctrl+Down
Shift+Ctrl+=
.TP
\fBCtrl+'\\'
Ctrl+Esc  (Workaround for Windows)
.TP
\fBShift+Ctrl+'\\'
Shift+Ctrl+Esc (Workaround for Windows)

.PP
CX85 Keypad (if enabled):
.TP
\fBhost keypad 0123456789-.
0123456789-.
.TP
\fBhost keypad /
NO
.TP
\fBhost keypad Ctrl+/
ESCAPE
.TP
\fBhost keypad *
DELETE
.TP
\fBhost keypad +
YES
.TP
\fBhost keypad Enter
+ENTER

.PP
Paddles, Atari touch tablet, Koala pad, light pen, light gun,
ST/Amiga mouse, Atari trak-ball, joystick and Atari 5200 analog
controller are emulated using mouse on ports that support it.
See the options above for how to enable mouse.

.SS Basic

No function keys or Alt+letter shortcuts.
Use Ctrl+C to enter the monitor.
Controllers not supported in this version.

.SS Curses

F10 (Save screenshot) does not work in the default CURSES_BASIC build.
Shift+F5 and Shift+F10 don't work at all.
Avoid Ctrl + C, H, J, M, Q, S and Z. The remaining control characters
can be typed. Control characters are displayed on the screen
with the associated upper case character in bold.

Controllers not supported in this version.

.SS Falcon

.TP
\fBHelp
Help key (XL/XE)

.PP
Joystick 0 is operated by the numeric keypad (make sure that the numeric
keypad has been enabled).

        7 8 9
         \\|/
        4 5 6
         /|\\
        1 2 3

        And 0 is the fire key.

Mouse not supported in this version.

.SS SDL

.TP
\fB`
Atari/Inverse key
.TP
\fBLSUPER
Atari/Inverse key (unusable under Windows)
.TP
\fBRSUPER
CapsToggle (+Shift = CapsLock)

.TP
\fBLAlt+F
Switch fullscreen/windowed display.
.TP
\fBLAlt+G
Switch visible horizontal area. See -horiz-area.
.TP
\fBLAlt+J
Swap \fBkeyboard_emulated\fP joysticks
.TP
\fBLAlt+M
Grab mouse (prevents mouse pointer from leaving the window)

.TP
\fBLAlt+LShift+1
Decrease hue (like TV Tint control, only NTSC)
.TP
\fBLAlt+1
Increase hue
.TP
\fBLAlt+LShift+2
Decrease saturation (like TV Colour control)
.TP
\fBLAlt+2
Increase saturation
.TP
\fBLAlt+LShift+3
Decrease contrast (also called white level)
.TP
\fBLAlt+3
Increase contrast
.TP
\fBLAlt+LShift+4
Decrease brightness (also called black level)
.TP
\fBLAlt+4
Increase brightness
.TP
\fBLAlt+LShift+5
Decrease gamma adjustment
.TP
\fBLAlt+5
Increase gamma adjustment
.TP
\fBLAlt+LShift+6
Decrease color delay (Atari color adjustment potentiometer, only NTSC)
.TP
\fBLAlt+6
Increase color delay

These keys work only in the NTSC filter mode (-ntscemu):
.TP
\fBLAlt+LShift+7
Decrease sharpness
.TP
\fBLAlt+7
Increase sharpness
.TP
\fBLAlt+LShift+8
Decrease resolution
.TP
\fBLAlt+8
Increase resolution
.TP
\fBLAlt+LShift+9
Decrease artifacts
.TP
\fBLAlt+9
Increase artifacts
.TP
\fBLAlt+LShift+0
Decrease fringing
.TP
\fBLAlt+0
Increase fringing
.TP
\fBLAlt+LShift+-
Decrease bleed
.TP
\fBLAlt+-
Increase bleed
.TP
\fBLAlt+LShift+=
Decrease NTSC burst phase (use this to change artifacting colours)
.TP
\fBLAlt+=
Increase NTSC burst phase
.TP
\fBLAlt+LShift+[
Decrease scanlines visibility
.TP
\fBLAlt+[
Increase scanlines visibility
.TP
\fBLAlt+]
Toggle NTSC composite/S-Video/RGB/monochrome settings


.TP
\fBLAlt+Shift+X
Enable/disable output of a 80 column hardware (use with -xep80, -proto80 or -af80).


.PP
Apart from standard joysticks (handled by the SDL) up to two keyboard joysticks
are supported. The keys used for joystick directions and the trigger can be
freely defined in the config UI (Controller Config -> Define layout).
Keyboard joystick emulation can be enabled/disabled in the Controller Config.
By default, joy 0 is enabled and joy 1 is disabled (to not steal normal
AWDS keys in the emulator).

.SS X11

.TP
\fBAlt
Atari key (either Alt key will work)

.PP
Joystick 0 is operated by the mouse position relative to the center of
the screen. The mouse button acts as the trigger.  On Linux, standard
joysticks are also supported.

.PD 1

.SH FILES
.TP
\fI/usr/share/atari800/ATARIOSA.ROM\fR
Atari O/S A
.TP
\fI/usr/share/atari800/ATARIOSB.ROM\fR
Atari O/S B
.TP
\fI/usr/share/atari800/ATARIXL.ROM\fR
Atari 800 XL O/S
.TP
\fI/usr/share/atari800/ATARI5200.ROM\fR
Atari 5200 O/S
.TP
\fI/usr/share/atari800/ATARIBAS.ROM\fR
Atari Basic

.SH BUGS
See the BUGS file.
