/***************************************************************************
                          agbrowser.cpp  -  description
                             -------------------
    begin                : Mon Feb 26 00:27:08 EST 2001
    copyright            : (C) 2001 by Joe Theriault
    email                : uallloveme@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include <iostream.h>

#include <qpixmap.h>
#include <qtooltip.h>
#include <qvaluelist.h>

#include <kapp.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kicontheme.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "agbrowser.h"


AGBrowser::AGBrowser( QWidget* parent,  const char* name, WFlags fl )
    : KMainWindow( parent, name, fl )
{
    // Toplevel Widgets
    resize( 752, 517 );
    setMaximumSize(752, 517);

    mainView = new QTabWidget( this, "mainView" );
    mainView->setGeometry( QRect( 0, 0, 750, 520 ) );
    mainView->setTabShape( QTabWidget::Rounded );

    setCentralWidget(mainView);


    // AudioGalaxy webview tab
    audiogalaxy_tab = new QWidget( mainView, "audiogalaxy_tab" );

    webView = new KHTMLPart(audiogalaxy_tab);
    webView->enableJScript(true);
    webView->enableJava(true);
    QValueList<int> fontSizes;
    webView->setFontSizes(fontSizes);
    connect( webView->browserExtension(),
        SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ),
        this, SLOT( openURLRequest(const KURL &, const KParts::URLArgs &) ) );
    webView->view()->setGeometry( QRect( 5, 45, 735, 430 ) );

    back_btn = new QPushButton( audiogalaxy_tab, "back_btn" );
    back_btn->setGeometry( QRect( 5, 5, 34, 34 ) );
    back_btn->setText( i18n( "" ) );
    back_btn->setPixmap( kapp->iconLoader()->loadIcon("back", KIcon::Toolbar, KIcon::SizeMedium,KIcon::DisabledState));
    back_btn->setAccel( 0 );
    back_btn->setFocusPolicy( QPushButton::NoFocus );
    connect(back_btn, SIGNAL(clicked()), this, SLOT(goBack()));

    forward_btn = new QPushButton( audiogalaxy_tab, "forward_btn" );
    forward_btn->setGeometry( QRect( 55, 5, 34, 34 ) );
    forward_btn->setText( i18n( "" ) );
    forward_btn->setPixmap( kapp->iconLoader()->loadIcon("forward", KIcon::Toolbar, KIcon::SizeMedium,KIcon::DisabledState) );
    forward_btn->setFocusPolicy( QPushButton::NoFocus );
    connect(forward_btn, SIGNAL(clicked()), this, SLOT(goForward()));

    home_btn = new QPushButton( audiogalaxy_tab, "home_btn" );
    home_btn->setGeometry( QRect( 105, 5, 34, 34 ) );
    home_btn->setText( i18n( "" ) );
    home_btn->setPixmap( kapp->iconLoader()->loadIcon("gohome", KIcon::Toolbar, KIcon::SizeMedium));
    home_btn->setFocusPolicy( QPushButton::NoFocus );
    connect(home_btn, SIGNAL(clicked()), this, SLOT(goHome()));

    reload_btn = new QPushButton( audiogalaxy_tab, "reload_btn" );
    reload_btn->setGeometry( QRect( 155, 5, 34, 34 ) );
    reload_btn->setText( i18n( "" ) );
    reload_btn->setPixmap( kapp->iconLoader()->loadIcon("reload", KIcon::Toolbar, KIcon::SizeMedium));
    reload_btn->setFocusPolicy( QPushButton::NoFocus );
    connect(reload_btn, SIGNAL(clicked()), this, SLOT(reload()));

    stop_btn = new QPushButton( audiogalaxy_tab, "stop_btn" );
    stop_btn->setGeometry( QRect( 205, 5, 34, 34 ) );
    stop_btn->setText( i18n( "" ) );
    stop_btn->setPixmap( kapp->iconLoader()->loadIcon("stop", KIcon::Toolbar, KIcon::SizeMedium,KIcon::DisabledState ));
    stop_btn->setFocusPolicy( QPushButton::NoFocus );
    connect(stop_btn, SIGNAL(clicked()), this, SLOT(stop()));

    QStringList frames;
    frames.append("sat-still");
    frames.append("sat-trans1");
    frames.append("sat-trans2");
    frames.append("sat-trans3");
    frames.append("sat-trans4");
    frames.append("sat-trans5");
    frames.append("sat-trans6");
    frames.append("sat-trans7");
    frames.append("sat-trans8");
    frames.append("sat-trans9");
    frames.append("sat-trans10");
    feedback_label = new KAnimWidget(frames, KIcon::SizeMedium, audiogalaxy_tab);
    feedback_label->setGeometry( QRect( 700, 5, 34, 34 ) );
    connect(webView, SIGNAL(completed()), this, SLOT(completed()));

    mainView->insertTab( audiogalaxy_tab, i18n( "AudioGalaxy" ) );


    // Settings tab
    settings_tab = new QWidget( mainView, "settings_tab" );

    username_lbl = new QLabel( settings_tab, "username_lbl" );
    username_lbl->setGeometry( QRect( 5, 10, 63, 14 ) );
    username_lbl->setText( i18n( "User Name" ) );

    username_edit = new KLineEdit( settings_tab, "KLineEdit1" );
    username_edit->setGeometry( QRect( 115, 10, 180, 20 ) );

    password_lbl = new QLabel( settings_tab, "password_lbl" );
    password_lbl->setGeometry( QRect( 5, 40, 54, 15 ) );
    password_lbl->setText( i18n( "Password" ) );

    password_edit = new KLineEdit( settings_tab, "KLineEdit1_2" );
    password_edit->setGeometry( QRect( 115, 40, 180, 20 ) );
    password_edit->setEchoMode(KLineEdit::Password);

    satelliteDir_lbl = new QLabel( settings_tab, "satelliteDir_lbl" );
    satelliteDir_lbl->setGeometry( QRect( 5, 70, 99, 15 ) );
    satelliteDir_lbl->setText( i18n( "Satellite Directory" ) );

    satelliteDir_kurlr = new KURLRequester( settings_tab, "satellireDir_kurlr" );
    satelliteDir_kurlr->fileDialog()->setMode(KFile::Directory);
    satelliteDir_kurlr->setGeometry( QRect( 115, 70, 208, 20 ) );

    downloadDir_lbl = new QLabel( settings_tab, "downloadDir_lbl" );
    downloadDir_lbl->setGeometry( QRect( 330, 10, 111, 15 ) );
    downloadDir_lbl->setText( i18n( "Download Directory" ) );

    downloadDir_kurlr = new KURLRequester( settings_tab, "downloadDir_kurlr" );
    downloadDir_kurlr->fileDialog()->setMode(KFile::Directory);
    downloadDir_kurlr->setGeometry( QRect( 448, 9, 208, 20 ) );

    shares_lbl = new QLabel( settings_tab, "shares_lbl" );
    shares_lbl->setGeometry( QRect( 330, 40, 104, 15 ) );
    shares_lbl->setText( i18n( "Shared Directories" ) );

    shared_list = new KListBox( settings_tab, "shared_list" );
    shared_list->setGeometry( QRect( 448, 40, 208, 160 ) );
    shared_list->setMultiSelection(true);

    add_share_btn = new QPushButton( settings_tab, "add_share_btn" );
    add_share_btn->setGeometry( QRect( 662, 40, 80, 26 ) );
    add_share_btn->setText( i18n( "Add" ) );
    connect(add_share_btn, SIGNAL(clicked()), this, SLOT(addShares()));

    remove_share_btn = new QPushButton( settings_tab, "remove_share_btn" );
    remove_share_btn->setGeometry( QRect( 662, 75, 80, 26 ) );
    remove_share_btn->setText( i18n( "Remove" ) );
    connect(remove_share_btn, SIGNAL(clicked()), this, SLOT(removeShares()));

    settings_sep1 = new QFrame( settings_tab, "settings_sep1" );
    settings_sep1->setGeometry( QRect( 0, 205, 745, 16 ) );
    settings_sep1->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    settings_sep1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, settings_sep1->sizePolicy().hasHeightForWidth() ) );

    home_lbl = new QLabel(settings_tab, "home_lbl");
    home_lbl->setGeometry(QRect(5, 225, 70, 15));
    home_lbl->setText( i18n( "Home Page"));

    home_grp = new QVButtonGroup(settings_tab, "home_grp");
    home_grp->setGeometry(QRect(5, 250, 134, 90));

    front_rad = new QRadioButton("audoigalaxy.com", home_grp, "front_rad");

    user_rad = new QRadioButton(i18n("Profile"), home_grp, "user_rad");

    queue_rad = new QRadioButton(i18n("Queue"), home_grp, "queue_rad");

    connect_chk = new QCheckBox( settings_tab, "connect_chk" );
    connect_chk->setGeometry( QRect( 16, 350, 134, 20 ) );
    connect_chk->setText( i18n( "Connect on Startup" ) );

    disconnect_chk = new QCheckBox( settings_tab, "disconnect_chk" );
    disconnect_chk->setGeometry( QRect( 16, 385, 131, 20 ) );
    disconnect_chk->setText( i18n( "Disconnect on Exit" ) );
    QToolTip::add(disconnect_chk, "This only functions if you didn't start the client independently.");

    font_lbl = new QLabel( settings_tab, "font_lbl" );
    font_lbl->setGeometry( QRect( 150, 225, 70, 15 ) );
    font_lbl->setText( i18n( "Font Size" ) );

    webViewFont_list = new KListBox(settings_tab, "webViewFont_list");
    webViewFont_list->insertItem("4");
    webViewFont_list->insertItem("5");
    webViewFont_list->insertItem("6");
    webViewFont_list->insertItem("7");
    webViewFont_list->insertItem("8");
    webViewFont_list->insertItem("9");
    webViewFont_list->insertItem("10");
    webViewFont_list->insertItem("11");
    webViewFont_list->insertItem("12");
    webViewFont_list->insertItem("13");
    webViewFont_list->insertItem("14");
    webViewFont_list->insertItem("15");
    webViewFont_list->insertItem("16");
    webViewFont_list->insertItem("17");
    webViewFont_list->insertItem("19");
    webViewFont_list->insertItem("20");
    webViewFont_list->insertItem("22");
    webViewFont_list->insertItem("24");
    webViewFont_list->insertItem("26");
    webViewFont_list->insertItem("28");
    webViewFont_list->insertItem("32");
    webViewFont_list->insertItem("48");
    webViewFont_list->insertItem("64");
    webViewFont_list->setGeometry(QRect(150, 250, 50, 165));

    settings_sep1_2 = new QFrame( settings_tab, "settings_sep1_2" );
    settings_sep1_2->setGeometry( QRect( 0, 420, 745, 16 ) );
    settings_sep1_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    settings_sep1_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, settings_sep1_2->sizePolicy().hasHeightForWidth() ) );

    apply_btn = new QPushButton( settings_tab, "apply_btn" );
    apply_btn->setGeometry( QRect( 650, 450, 80, 26 ) );
    apply_btn->setText( i18n( "Apply" ) );
    connect(apply_btn, SIGNAL(clicked()), this, SLOT(applySettings()));

    restore_btn = new QPushButton( settings_tab, "restore_btn" );
    restore_btn->setGeometry( QRect( 540, 450, 80, 26 ) );
    restore_btn->setText( i18n( "Restore" ) );
    connect(restore_btn, SIGNAL(clicked()), this, SLOT(resetSettings()));

    mainView->insertTab( settings_tab, i18n( "Settings" ) );


    // Post-GUI-Creation Setup
    agconfig = NULL;

    client = new KProcess();
    connect(client, SIGNAL(processExited(KProcess* )), this, SLOT(clientDied()));

    historyPast = new QStack<KURL>();
    historyFuture = new QStack<KURL>();

    clearFuture = true;

    trayView = new AGTray(this);
    trayView->show();

    fillSettingsForm();

    shouldBeConnected = false;

    if(kapp->config()->readEntry("Connect") == "true")
    {
      runSatellite();
      goHome();
    }
}

AGBrowser::~AGBrowser()
{
  if(kapp->config()->readEntry("Disconnect") == "true")
  {
    shouldBeConnected = false;
    client->kill();
  }

  delete client;
  delete agconfig;
  delete historyPast;
  delete historyFuture;
}


// SLOTS
void AGBrowser::goBack()
{
  if(historyPast->top())
  {
    KURL* url = historyPast->pop();
    addFuture();

    addToPast = false;
    KParts::URLArgs placebo;
    clearFuture = false;
    openURLRequest((*url), placebo);

    if(!historyPast->top())
      back_btn->setPixmap(kapp->iconLoader()->loadIcon("back", KIcon::Toolbar, KIcon::SizeMedium, KIcon::DisabledState));
  }

}

void AGBrowser::goForward()
{
  if(historyFuture->top())
  {
    KURL* url = historyFuture->pop();
    addPast();

    KParts::URLArgs placebo;
    openURLRequest((*url), placebo);

    if(!historyFuture->top())
      forward_btn->setPixmap(kapp->iconLoader()->loadIcon("forward", KIcon::Toolbar, KIcon::SizeMedium, KIcon::DisabledState));
  }
}

void AGBrowser::goHome()
{
  kapp->config()->setGroup("Global");
  KURL url = kapp->config()->readEntry("Homepage");

  KParts::URLArgs placebo;
  openURLRequest(url, placebo);
}

void AGBrowser::reload()
{
  KParts::URLArgs placebo;
  addToPast = false;
  openURLRequest(webView->url(), placebo);
}

void AGBrowser::stop()
{
  webView->closeURL();
  completed();
}

void AGBrowser::openURLRequest(const KURL &url, const KParts::URLArgs&)
{
  if(clearFuture)
  {
    historyFuture->clear();
    forward_btn->setPixmap(kapp->iconLoader()->loadIcon("forward", KIcon::Toolbar, KIcon::SizeMedium, KIcon::DisabledState));
  }
  clearFuture = true;
  addPast();
  feedback_label->start();
  stop_btn->setPixmap( kapp->iconLoader()->loadIcon("stop", KIcon::Toolbar, KIcon::SizeMedium));
  webView->openURL(url);
}


void AGBrowser::addShares()
{
  shared_list->insertStringList(KFileDialog::getExistingDirectory());
}

void AGBrowser::removeShares()
{
  for(int currentShare = shared_list->count() - 1; currentShare >= 0; currentShare--)
  {
    if(shared_list->isSelected(currentShare))
      shared_list->removeItem(currentShare);
  }
}

void AGBrowser::applySettings()
{
  readSettingsForm();
  fillSettingsForm();
}

void AGBrowser::resetSettings()
{
  fillSettingsForm();
}

void AGBrowser::completed()
{
  feedback_label->stop();
  stop_btn->setPixmap( kapp->iconLoader()->loadIcon("stop", KIcon::Toolbar, KIcon::SizeMedium,KIcon::DisabledState ));
}

void AGBrowser::clientDied()
{
  emit AGdisconnected();

  if(shouldBeConnected)
  {
    if(KMessageBox::warningYesNo (this, i18n("You've been disconnected from the AudioGalaxy network.\n\nWould you like to try to reconnect now?")) == KMessageBox::Yes)
      runSatellite();
    else
      shouldBeConnected = false;
  }
}

void AGBrowser::connectAG()
{
  runSatellite();
}

void AGBrowser::disconnectAG()
{
  shouldBeConnected = false;
  client->kill();
}


// PROTECTED
void AGBrowser::addPast()
{
  if(addToPast)
  {
    if(historyPast->top())
      back_btn->setPixmap( kapp->iconLoader()->loadIcon("back", KIcon::Toolbar, KIcon::SizeMedium));
    KURL* url_p = new KURL(webView->url());
    historyPast->push(url_p);
  }
  else
    addToPast = true;
}

void AGBrowser::addFuture()
{
  forward_btn->setPixmap( kapp->iconLoader()->loadIcon("forward", KIcon::Toolbar, KIcon::SizeMedium));
  KURL* url_p = new KURL(webView->url());
  historyFuture->push(url_p);
}

void AGBrowser::fillSettingsForm()
{
  QString currentSetting;

  kapp->config()->setGroup("Global");
  currentSetting = kapp->config()->readEntry("SatelliteDir");
  if(!currentSetting.isEmpty())
  {
    satelliteDir_kurlr->setURL(currentSetting);
    if(!agconfig)
      agconfig = new AGConfig(currentSetting);
    else
      agconfig->read();

    username_edit->setText(agconfig->getName());
    password_edit->setText(agconfig->getPass());
    downloadDir_kurlr->setURL(agconfig->getDLDir());
    shared_list->clear();
    shared_list->insertStringList(agconfig->getShares());
  }
  else
  {
    satelliteDir_kurlr->setURL("");
    KMessageBox::sorry(this, i18n("Please select the directory where the AudioGalaxy Satellite program\n\"AGSatellite\" is located in the settings tab."));
  }

  currentSetting = kapp->config()->readEntry("Connect");
  if(currentSetting)
  {
    if(currentSetting == "false")
      connect_chk->setChecked(false);
    else
      connect_chk->setChecked(true);
  }

  currentSetting = kapp->config()->readEntry("Disconnect");
  if(currentSetting)
  {
    if(currentSetting == "false")
      disconnect_chk->setChecked(false);
    else
     disconnect_chk->setChecked(true);
  }

  currentSetting = kapp->config()->readEntry("Homepage");
  if(currentSetting)
  {
    if(currentSetting == "http://www.audiogalaxy.com")
      front_rad->setChecked(true);
    else if(currentSetting == "http://www.audiogalaxy.com/user/home.php?")
     user_rad->setChecked(true);
    else
      queue_rad->setChecked(true);
  }

  currentSetting = kapp->config()->readEntry("FontSize");
  if(currentSetting)
    webViewFont_list->setCurrentItem(webViewFont_list->findItem(currentSetting));
  else
    webViewFont_list->setCurrentItem(webViewFont_list->findItem("12"));
  QValueList<int> htmlFonts;
  for(; htmlFonts.count() < 8; htmlFonts.append(webViewFont_list->currentText().toInt()));
  webView->setFontSizes(htmlFonts);
}

void AGBrowser::readSettingsForm()
{
  QString currentSetting;

  kapp->config()->setGroup("Global");
  currentSetting = satelliteDir_kurlr->url();
  kapp->config()->writeEntry("SatelliteDir",currentSetting);
  if(!currentSetting.isEmpty())
  {
    if(!agconfig) agconfig = new AGConfig(currentSetting);
    agconfig->setName(username_edit->text());
    agconfig->setPass(password_edit->text());
    agconfig->setDLDir(downloadDir_kurlr->url());

    QStringList shares;
    for(int index = 0; index < shared_list->count(); index++)
      shares += shared_list->text(index);
    agconfig->setShares(shares);
    agconfig->write();
  }

  if(connect_chk->isChecked())
    kapp->config()->writeEntry("Connect", "true");
  else
    kapp->config()->writeEntry("Connect", "false");

  if(disconnect_chk->isChecked())
    kapp->config()->writeEntry("Disconnect", "true");
  else
    kapp->config()->writeEntry("Disconnect", "false");

  if(front_rad->isChecked())
    kapp->config()->writeEntry("Homepage", "http://www.audiogalaxy.com");
  else if(user_rad->isChecked())
    kapp->config()->writeEntry("Homepage", "http://www.audiogalaxy.com/user/home.php?");
  else
    kapp->config()->writeEntry("Homepage", "http://www.audiogalaxy.com/satellite/queue.php?");

  kapp->config()->writeEntry("FontSize", webViewFont_list->currentText());

  kapp->config()->sync();
}

void AGBrowser::runSatellite()
{
  QString satDir = kapp->config()->readEntry("SatelliteDir");
  if(!satDir.isEmpty())
  {
    if(!client->isRunning())
    {
      chdir(satDir);
      client->clearArguments();
      (*client) << "AGSatellite";
      client->start();
      shouldBeConnected = true;

      emit AGconnected();
    }
  }
  else
    KMessageBox::sorry(this, i18n("Please select the directory where the AudioGalaxy Satellite program\n\"AGSatellite\" is located in the settings tab."));
}

void AGBrowser::manageMp3s()
{
  if(agconfig)
    shareManager.open(agconfig->getDLDir(), agconfig->getShares());
}
