;;;
;;; $Id: tm-mh-e3.el,v 7.1 1995/12/04 03:43:30 morioka Exp $
;;;
;;; This is a part of tm-mh-e.el which is a module for old mh-e
;;; to emulate mh-e 4.*.
;;;
;;; This module imports from mh-e 4.1.
;;;

(require 'mh-e)


(defvar mail-citation-hook nil
  "*Hook for modifying a citation just inserted in the mail buffer.
Each hook function can find the citation between point and mark.
And each hook function should leave point and mark around the citation
text as modified.")


;;; Ensure new buffers won't get this mode if default-major-mode is nil.
(put 'mh-show-mode 'mode-class 'special)

(defun mh-show-mode ()
  "Major mode for showing messages in mh-e.
The value of mh-show-mode-hook is called when a new message is displayed."
  (kill-all-local-variables)
  (setq major-mode 'mh-show-mode)
  (mh-set-mode-name "MH-Show")
  (run-hooks 'mh-show-mode-hook))

(defun mh-start-of-uncleaned-message ()
  ;; position uninteresting headers off the top of the window
  (let ((case-fold-search t))
    (re-search-forward
     "^To:\\|^From:\\|^Subject:\\|^Date:" nil t)
    (beginning-of-line)
    (mh-recenter 0)))

(fset 'mh-show-msg (symbol-function 'mh-show))


;;; @ mh-comp definitions
;;;

(provide 'mh-comp)

(defun mh-read-address (prompt)
  ;; Read a To: or Cc: address, prompting in the minibuffer with PROMPT.
  ;; May someday do completion on aliases.
  (read-string prompt))

(defvar mh-forward-subject-format "%s: %s"
  "*Format to generate the Subject: line contents for a forwarded message.
The two string arguments to the format are the sender of the original
message and the original subject line.")

(defun mh-forwarded-letter-subject (from subject)
  ;; Return a Subject suitable for a forwarded message.
  ;; Original message has headers FROM and SUBJECT.
  (let ((addr-start (string-match "<" from))
	(comment (string-match "(" from)))
    (cond ((and addr-start (> addr-start 0))
	   ;; Full Name <luser@host>
	   (setq from (substring from 0 (1- addr-start))))
	  (comment
	   ;; luser@host (Full Name)
	   (setq from (substring from (1+ comment) (1- (length from)))))))
  (format mh-forward-subject-format from subject))


;;; @ end
;;;

(provide 'tm-mh-e3)
