//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name :       madjust.C
//
// Purpose :    Implementation of class MAdjustable
//
// Created :    12 Apr 94    Bernhard Marschall
// Modified :   19 Jan 95    Bernhard Marschall
//
// $Id: madjust.C,v 1.4 1996/10/16 13:08:47 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: madjust.C,v $
// Revision 1.4  1996/10/16 13:08:47  bmarsch
// Bugfix: exchanged call order of ref/unref in changing colors
//
// Revision 1.3  1996/07/25 12:31:56  bmarsch
// Include limits.h instead of values.h
//
// Revision 1.2  1996/03/13 12:47:01  bmarsch
// Bugfix: initialize marked interval
//
// Revision 1.1  1996/03/12 16:54:59  bmarsch
// Initial revision
//

#include <limits.h>

#include "madjust.h"
#include <InterViews/color.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <IV-look/kit.h>

#include <hyperg/utils/str.h>

// *************************************************************************

MAdjustable::MAdjustable(float lower, float upper)
: AdjValue(lower, upper, 0.01, 0.1)
{
  // init
  markLower_ = markUpper_ = 0.0;
  marking_ = false;

  // init colors with some default (I like it ...)
  Display* dpy = Session::instance()->default_display();
  markColor_ = Color::lookup(dpy, "#C2FE45");
  Resource::ref(markColor_);
  setColor_ = markColor_;
  Resource::ref(setColor_);
  drawColor_ = markColor_;
}

// *************************************************************************

MAdjustable::~MAdjustable()
{
  // free colors
  Resource::unref(markColor_);
  Resource::unref(setColor_);
}

// *************************************************************************

void MAdjustable::startMarking(float low)
{
  // constrain value
  if (low < lower_)
    low = lower_;
  if (low > upper_)
    low = upper_;

  // init marking bounds
  markLower_ = markUpper_ = low;
  // start marking
  marking_ = true;
  // set marking color
  drawColor_ = markColor_;
}

// *************************************************************************

void MAdjustable::stopMarking(float up)
{
  // constrain value
  if (up < lower_)
    up = lower_;
  if (up > upper_)
    up = upper_;

  // stop marking
  marking_ = false;

  // mark nothing if bounds are equal
  if (up == markLower_) {
    markLower_ = markUpper_ = 0.0;
    return;
  }

  // switch values so that markLower_ <= markUpper_
  if (up < markLower_)
    markLower_ = up;
  else
    markUpper_ = up;
}

// *************************************************************************

void MAdjustable::set_value(float val)
{
  // set the current value
  AdjValue::scroll_to(Dimension_X, val);
}

// *************************************************************************

void MAdjustable::setMarked(float start, float stop)
{
  // constrain bounds
  if (start < lower_)
    start = lower_;
  if (start > upper_)
    start = upper_;
  if (stop < lower_)
    stop = lower_;
  if (stop > upper_)
    stop = upper_;
  // make start <= stop
  if (start > stop) {
    float d = start;
    start = stop;
    stop = d;
  }

  // save bounds
  markLower_ = start;
  markUpper_ = stop;
  // set drawing colors
  drawColor_ = setColor_;
}

// *************************************************************************

void MAdjustable::markColor(const Color* col)
{
  Resource::ref(col);
  // set new markerColor
  if (markColor_ == drawColor_)
    drawColor_ = col;
  Resource::unref(markColor_);
  markColor_ = col;
}

// *************************************************************************

void MAdjustable::setColor(const Color* col)
{
  // set new destinationColor
  Resource::ref(col);
  if (setColor_ == drawColor_)
    drawColor_ = col;
  Resource::unref(setColor_);
  setColor_ = col;
}
