/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1997 Netscape Communications Corporation.  All Rights
 * Reserved.
 */



// CBiffButtonAttachment.h

#pragma once

#include "LAttachment.h"

class LControl;

//======================================
class CBiffButtonAttachment : public LAttachment, public LListener
// Just attach this to a control.  It will listen for biff broadcasts and
// set the icon id of its host button accordingly.  There is no ExecuteSelf method,
// we are only using this attachment so we can add it in Constructor, and it
// will figure out which button it is attached to.
//======================================
{
public:
	enum { class_ID = 'BfAt' };
					CBiffButtonAttachment(LStream* inStream);
	virtual			~CBiffButtonAttachment();
	virtual void	ListenToMessage(MessageT inMeesage, void* ioParam);
protected:
	virtual void	ExecuteSelf(
							MessageT		inMessage,
							void			*ioParam);
protected:
	LControl*		mButton;
	ResIDT			mResIDList[3]; // indexed by MSG_BIFF_STATE
}; // class CBiffButtonAttachment

