/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.FormattingSerializer;
import netscape.util.HashtableEnumerator;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Hashtable
implements Cloneable,
Codable {
    static final int A = -1640531527;
    static final int EMPTY = 0;
    static final int REMOVED = 1;
    static final int DEFAULT = 2;
    static final String keysField = "keys";
    static final String elementsField = "elements";
    int count;
    int totalCount;
    int shift = 30;
    int capacity;
    int indexMask;
    int[] hashCodes;
    Object[] keys;
    Object[] elements;

    public Hashtable() {
    }

    public Hashtable(int initialCapacity) {
        this();
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be > 0");
        }
        this.grow(initialCapacity);
    }

    public Object clone() {
        Hashtable newTable;
        try {
            newTable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error in clone(). This shouldn't happen.");
        }
        if (this.count == 0) {
            newTable.shift = 30;
            newTable.totalCount = 0;
            newTable.capacity = 0;
            newTable.indexMask = 0;
            newTable.hashCodes = null;
            newTable.keys = null;
            newTable.elements = null;
            return newTable;
        }
        int len = this.hashCodes.length;
        newTable.hashCodes = new int[len];
        newTable.keys = new Object[len];
        newTable.elements = new Object[len];
        System.arraycopy(this.hashCodes, 0, newTable.hashCodes, 0, len);
        System.arraycopy(this.keys, 0, newTable.keys, 0, len);
        System.arraycopy(this.elements, 0, newTable.elements, 0, len);
        return newTable;
    }

    public int count() {
        return this.count;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this, true);
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this, false);
    }

    public Vector keysVector() {
        if (this.count == 0) {
            return new Vector();
        }
        Vector vect = new Vector(this.count);
        int vectCount = 0;
        int i = 0;
        while (i < this.keys.length && vectCount < this.count) {
            Object key = this.keys[i];
            if (key != null) {
                vect.addElement(key);
                ++vectCount;
            }
            ++i;
        }
        return vect;
    }

    public Vector elementsVector() {
        if (this.count == 0) {
            return new Vector();
        }
        Vector vect = new Vector(this.count);
        int vectCount = 0;
        int i = 0;
        while (i < this.elements.length && vectCount < this.count) {
            Object element = this.elements[i];
            if (element != null) {
                vect.addElement(element);
                ++vectCount;
            }
            ++i;
        }
        return vect;
    }

    public Object[] keysArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] array = new Object[this.count];
        int arrayCount = 0;
        int i = 0;
        while (i < this.keys.length && arrayCount < this.count) {
            Object key = this.keys[i];
            if (key != null) {
                array[arrayCount++] = key;
            }
            ++i;
        }
        return array;
    }

    public Object[] elementsArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] array = new Object[this.count];
        int arrayCount = 0;
        int i = 0;
        while (i < this.elements.length && arrayCount < this.count) {
            Object element = this.elements[i];
            if (element != null) {
                array[arrayCount++] = element;
            }
            ++i;
        }
        return array;
    }

    public boolean contains(Object element) {
        if (this.count == 0) {
            return false;
        }
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.elements == null) {
            return false;
        }
        int i = 0;
        while (i < this.elements.length) {
            Object tmp = this.elements[i];
            if (tmp != null && element.equals(tmp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        if (this.count == 0) {
            return null;
        }
        return this.elements[this.tableIndexFor(key, this.hash(key))];
    }

    public Object remove(Object key) {
        if (this.count == 0) {
            return null;
        }
        int index = this.tableIndexFor(key, this.hash(key));
        Object oldValue = this.elements[index];
        if (oldValue == null) {
            return null;
        }
        --this.count;
        this.hashCodes[index] = 1;
        this.keys[index] = null;
        this.elements[index] = null;
        return oldValue;
    }

    public Object put(Object key, Object element) {
        int hash;
        int index;
        Object oldValue;
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.hashCodes == null) {
            this.grow();
        }
        if ((oldValue = this.elements[index = this.tableIndexFor(key, hash = this.hash(key))]) == null) {
            if (this.hashCodes[index] == 0) {
                if (this.totalCount >= this.capacity) {
                    this.grow();
                    return this.put(key, element);
                }
                ++this.totalCount;
            }
            ++this.count;
        }
        this.hashCodes[index] = hash;
        this.keys[index] = key;
        this.elements[index] = element;
        return oldValue;
    }

    private int hash(Object key) {
        int hash = key.hashCode();
        if (hash == 0 || hash == 1) {
            hash = 2;
        }
        return hash;
    }

    private int tableIndexFor(Object key, int hash) {
        int removedIndex;
        int product = hash * -1640531527;
        int index = product >>> this.shift;
        int testHash = this.hashCodes[index];
        if (testHash == hash) {
            if (key.equals(this.keys[index])) {
                return index;
            }
            removedIndex = -1;
        } else {
            if (testHash == 0) {
                return index;
            }
            removedIndex = testHash == 1 ? index : -1;
        }
        int step = product >>> 2 * this.shift - 32 & this.indexMask | 1;
        int probeCount = 1;
        do {
            ++probeCount;
            testHash = this.hashCodes[index = index + step & this.indexMask];
            if (testHash == hash) {
                if (!key.equals(this.keys[index])) continue;
                return index;
            }
            if (testHash == 0) {
                if (removedIndex < 0) {
                    return index;
                }
                return removedIndex;
            }
            if (testHash != 1 || removedIndex != -1) continue;
            removedIndex = index;
        } while (probeCount <= this.totalCount);
        throw new InconsistencyException("Hashtable overflow");
    }

    private void grow(int capacity) {
        int tableSize = capacity * 4 / 3;
        int power = 3;
        while (1 << power < tableSize) {
            ++power;
        }
        this.shift = 32 - power + 1;
        this.grow();
    }

    private void grow() {
        --this.shift;
        int power = 32 - this.shift;
        this.indexMask = (1 << power) - 1;
        this.capacity = 3 * (1 << power) / 4;
        int[] oldHashCodes = this.hashCodes;
        Object[] oldKeys = this.keys;
        Object[] oldValues = this.elements;
        this.hashCodes = new int[1 << power];
        this.keys = new Object[1 << power];
        this.elements = new Object[1 << power];
        this.totalCount = 0;
        if (this.count > 0) {
            this.count = 0;
            int i = 0;
            while (i < oldHashCodes.length) {
                Object key = oldKeys[i];
                if (key != null) {
                    int hash = oldHashCodes[i];
                    int index = this.tableIndexFor(key, hash);
                    this.hashCodes[index] = hash;
                    this.keys[index] = key;
                    this.elements[index] = oldValues[i];
                    ++this.count;
                    ++this.totalCount;
                }
                ++i;
            }
        }
    }

    public void clear() {
        if (this.hashCodes == null) {
            return;
        }
        int i = 0;
        while (i < this.hashCodes.length) {
            this.hashCodes[i] = 0;
            this.keys[i] = null;
            this.elements[i] = null;
            ++i;
        }
        this.count = 0;
        this.totalCount = 0;
    }

    public String toString() {
        return FormattingSerializer.serializeObject(this);
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.util.Hashtable", 1);
        info.addField(keysField, (byte)19);
        info.addField(elementsField, (byte)19);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.count == 0) {
            return;
        }
        Object[] keysArray = this.keysArray();
        Object[] elementsArray = this.elementsArray();
        encoder.encodeObjectArray(keysField, keysArray, 0, keysArray.length);
        encoder.encodeObjectArray(elementsField, elementsArray, 0, elementsArray.length);
    }

    public void decode(Decoder decoder) throws CodingException {
        Object[] keysArray = decoder.decodeObjectArray(keysField);
        Object[] elementsArray = decoder.decodeObjectArray(elementsField);
        if (keysArray == null || keysArray.length == 0) {
            return;
        }
        this.grow(keysArray.length);
        int i = 0;
        while (i < keysArray.length) {
            this.put(keysArray[i], elementsArray[i]);
            ++i;
        }
    }

    public void finishDecoding() throws CodingException {
    }
}

