/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.ListItem;
import netscape.application.Popup;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class PopupItem
extends ListItem {
    Popup popup;
    static final String POPUP_KEY = "popup";

    public void setPopup(Popup aPopup) {
        this.popup = aPopup;
    }

    public Popup popup() {
        return this.popup;
    }

    public void drawInRect(Graphics g, Rect boundsRect) {
        PopupItem selectedItem;
        super.drawInRect(g, boundsRect);
        if (this.popup != null && (selectedItem = (PopupItem)this.popup.selectedItem()).equals(this)) {
            int height;
            int width;
            Image popupImage = this.popup.popupImage();
            if (popupImage != null) {
                width = popupImage.width();
                height = popupImage.height();
            } else {
                height = 0;
                width = 0;
            }
            if (this.selected) {
                g.setColor(this.selectedColor);
            } else {
                g.setColor(this.listView.backgroundColor());
            }
            g.fillRect(boundsRect.x + boundsRect.width - width - 4, boundsRect.y, width + 4, boundsRect.height);
            if (popupImage != null) {
                popupImage.drawAt(g, boundsRect.x + boundsRect.width - width - 2, boundsRect.y + (boundsRect.height - height) / 2);
            }
        }
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.PopupItem", 1);
        info.addField(POPUP_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(POPUP_KEY, this.popup);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.popup = (Popup)decoder.decodeObject(POPUP_KEY);
    }
}

