/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.LayoutManager;
import netscape.application.Size;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class GridLayout
implements LayoutManager,
Codable {
    int rowCount;
    int columnCount;
    int horizGap;
    int vertGap;
    int flowDirection;
    public static final int FLOW_ACROSS = 0;
    public static final int FLOW_DOWN = 1;
    static final String ROWCOUNT_KEY = "rowCount";
    static final String COLUMNCOUNT_KEY = "columnCount";
    static final String HORIZGAP_KEY = "horizGap";
    static final String VERTGAP_KEY = "vertGap";
    static final String FLOWDIRECTION_KEY = "flowDirection";

    public GridLayout() {
        this(0, 0, 0, 0, 0);
    }

    public GridLayout(int numRows, int numCols) {
        this(numRows, numCols, 0, 0, 0);
    }

    public GridLayout(int numRows, int numCols, int horizGap, int vertGap, int flow) {
        this.setRowCount(numRows);
        this.setColumnCount(numCols);
        this.horizGap = horizGap;
        this.vertGap = vertGap;
        this.setFlowDirection(flow);
    }

    public void setRowCount(int numRows) {
        this.rowCount = numRows >= 0 ? numRows : 0;
    }

    public int rowCount() {
        return this.rowCount;
    }

    public void setColumnCount(int numCols) {
        this.columnCount = numCols >= 0 ? numCols : 0;
    }

    public int columnCount() {
        return this.columnCount;
    }

    public void setHorizGap(int gap) {
        this.horizGap = gap;
    }

    public int horizGap() {
        return this.horizGap;
    }

    public void setVertGap(int gap) {
        this.vertGap = gap;
    }

    public int vertGap() {
        return this.vertGap;
    }

    public void setFlowDirection(int flow) {
        if (flow == 0 || flow == 1) {
            this.flowDirection = flow;
            return;
        }
        throw new InconsistencyException(String.valueOf(this) + "Invalid Flow direction specified: " + flow);
    }

    public int flowDirection() {
        return this.flowDirection;
    }

    public void addSubview(View aView) {
    }

    public void removeSubview(View aView) {
    }

    public void layoutView(View aView, int deltaWidth, int deltaHeight) {
        Vector theViews = aView.subviews();
        int max = theViews.count();
        if (max < 1) {
            return;
        }
        Size realGridSize = this.gridSize(aView);
        int nCols = realGridSize.width;
        int nRows = realGridSize.height;
        int aveWidth = (aView.bounds.width - this.horizGap * nCols - this.horizGap) / nCols;
        int aveHeight = (aView.bounds.height - this.vertGap * nRows - this.vertGap) / nRows;
        int curRow = 0;
        int curCol = 0;
        if (this.flowDirection == 1) {
            int cnt = 0;
            while (cnt < max) {
                int x = aveWidth * curCol + this.horizGap * (curCol + 1);
                int y = aveHeight * curRow + this.vertGap * (curRow + 1);
                View currView = (View)theViews.elementAt(cnt);
                currView.setBounds(x, y, aveWidth, aveHeight);
                if (nRows > 0 && ++curRow >= nRows) {
                    ++curCol;
                    curRow = 0;
                }
                ++cnt;
            }
            return;
        }
        int cnt = 0;
        while (cnt < max) {
            int x = aveWidth * curCol + this.horizGap * (curCol + 1);
            int y = aveHeight * curRow + this.vertGap * (curRow + 1);
            View currView = (View)theViews.elementAt(cnt);
            currView.setBounds(x, y, aveWidth, aveHeight);
            if (nCols > 0 && ++curCol >= nCols) {
                ++curRow;
                curCol = 0;
            }
            ++cnt;
        }
    }

    public Size gridSize(View aView) {
        int estRows;
        int estCols;
        int totalViews = aView.subviews().count();
        if (totalViews < 1) {
            return new Size();
        }
        if (this.rowCount == 0) {
            if (this.columnCount == 0) {
                estRows = estCols = (int)Math.ceil(Math.sqrt(totalViews));
            } else {
                estCols = this.columnCount;
                estRows = (int)Math.ceil((float)totalViews / (float)estCols);
            }
        } else if (this.columnCount == 0) {
            if (this.rowCount == 0) {
                estRows = estCols = (int)Math.ceil(Math.sqrt(totalViews));
            } else {
                estRows = this.rowCount;
                estCols = (int)Math.ceil((float)totalViews / (float)estRows);
            }
        } else {
            estRows = this.rowCount;
            estCols = this.columnCount;
        }
        return new Size(estCols, estRows);
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.GridLayout", 1);
        info.addField(ROWCOUNT_KEY, (byte)8);
        info.addField(COLUMNCOUNT_KEY, (byte)8);
        info.addField(HORIZGAP_KEY, (byte)8);
        info.addField(VERTGAP_KEY, (byte)8);
        info.addField(FLOWDIRECTION_KEY, (byte)8);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.rowCount = decoder.decodeInt(ROWCOUNT_KEY);
        this.columnCount = decoder.decodeInt(COLUMNCOUNT_KEY);
        this.horizGap = decoder.decodeInt(HORIZGAP_KEY);
        this.vertGap = decoder.decodeInt(VERTGAP_KEY);
        this.flowDirection = decoder.decodeInt(FLOWDIRECTION_KEY);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(ROWCOUNT_KEY, this.rowCount);
        encoder.encodeInt(COLUMNCOUNT_KEY, this.columnCount);
        encoder.encodeInt(HORIZGAP_KEY, this.horizGap);
        encoder.encodeInt(VERTGAP_KEY, this.vertGap);
        encoder.encodeInt(FLOWDIRECTION_KEY, this.flowDirection);
    }

    public void finishDecoding() throws CodingException {
    }
}

