/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.DragDestination;
import netscape.application.DragSource;
import netscape.application.DragView;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.View;

public class DragSession {
    String dataType;
    Object data;
    Image image;
    int initialX;
    int initialY;
    int mouseDownX;
    int mouseDownY;
    int mouseX;
    int mouseY;
    DragSource source;
    DragDestination destination;
    DragView dragView;
    int modifiers;
    RootView rootView;
    View sourceView;
    View destinationView;
    boolean isAccepting;
    public static final int SHIFT_MASK = 1;
    public static final int CONTROL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;

    public DragSession(DragSource source, Image image, int initialX, int initialY, int mouseDownX, int mouseDownY, String dataType, Object data, boolean createDragView) {
        Point initialPoint = new Point();
        Point mousePoint = new Point();
        this.sourceView = source.sourceView(this);
        this.rootView = this.sourceView.rootView();
        this.sourceView.convertToView(null, initialX, initialY, initialPoint);
        this.sourceView.convertToView(null, mouseDownX, mouseDownY, mousePoint);
        if (this.rootView.windowClipView() != null) {
            this.rootView.convertPointToView(this.rootView.windowClipView(), initialPoint, initialPoint);
            this.rootView.convertPointToView(this.rootView.windowClipView(), mousePoint, mousePoint);
        }
        this.source = source;
        this.image = image;
        this.initialX = initialPoint.x;
        this.initialY = initialPoint.y;
        this.mouseDownX = mousePoint.x;
        this.mouseDownY = mousePoint.y;
        this.dataType = dataType;
        this.data = data;
        if (createDragView) {
            this.dragView = new DragView(this);
        }
    }

    public DragSession(DragSource source, Image image, int initialX, int initialY, int mouseDownX, int mouseDownY, String dataType, Object data) {
        this(source, image, initialX, initialY, mouseDownX, mouseDownY, dataType, data, true);
    }

    public Object data() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String dataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public DragSource source() {
        return this.source;
    }

    public DragDestination destination() {
        return this.destination;
    }

    public int dragModifiers() {
        return this.modifiers;
    }

    public boolean isShiftKeyDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlKeyDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaKeyDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAltKeyDown() {
        return (this.modifiers & 8) != 0;
    }

    void updateModifiers(MouseEvent currentEvent) {
        this.modifiers = 0;
        if (currentEvent == null) {
            return;
        }
        if (currentEvent.isShiftKeyDown()) {
            ++this.modifiers;
        }
        if (currentEvent.isControlKeyDown()) {
            this.modifiers += 2;
        }
        if (currentEvent.isMetaKeyDown()) {
            this.modifiers += 4;
        }
        if (currentEvent.isAltKeyDown()) {
            this.modifiers += 8;
        }
    }

    public void mouseDragged(MouseEvent event) {
        DragDestination dest = null;
        Point aPoint = new Point(event.x, event.y);
        if (this.dragView != null) {
            this.dragView.convertPointToView(null, aPoint, aPoint);
        }
        int x = aPoint.x;
        int y = aPoint.y;
        this.updateModifiers(event);
        View view = this.rootView.viewForMouse(x, y);
        if (this.rootView.viewExcludedFromModalSession(view)) {
            view = null;
        }
        if (view != null) {
            Point point = Point.newPoint();
            this.rootView.convertToView(view, x, y, point);
            dest = view.acceptsDrag(this, point.x, point.y);
            while (dest == null && view._superview != null) {
                point.x += view.bounds.x;
                point.y += view.bounds.y;
                view = view._superview;
                dest = view.acceptsDrag(this, point.x, point.y);
            }
            Point.returnPoint(point);
        }
        if (this.destination == null && dest != null) {
            this.destination = dest;
            this.destinationView = view;
            this.isAccepting = this.destination.dragEntered(this);
            return;
        }
        if (this.destination != null && dest == null) {
            this.destination.dragExited(this);
            this.destination = null;
            this.destinationView = null;
            return;
        }
        if (this.destination != dest) {
            this.destination.dragExited(this);
            this.destination = dest;
            this.destinationView = view;
            this.destination.dragEntered(this);
            return;
        }
        if (this.destination != null) {
            this.isAccepting = this.destination.dragMoved(this);
        }
    }

    public void mouseUp(MouseEvent event) {
        boolean animateBack;
        block9: {
            boolean accepted = false;
            animateBack = false;
            try {
                this.updateModifiers(event);
                if (this.destination != null && this.isAccepting) {
                    accepted = this.destination.dragDropped(this);
                }
                if (accepted) {
                    this.source.dragWasAccepted(this);
                    break block9;
                }
                animateBack = this.source.dragWasRejected(this);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_5 = null;
                    this.isAccepting = false;
                    if (this.dragView == null) break block10;
                    if (animateBack) {
                        this.dragView.startAnimatingRejectedDrag();
                    } else {
                        this.dragView.stopDragging();
                    }
                }
                throw throwable;
            }
        }
        Object var5_4 = null;
        this.isAccepting = false;
        if (this.dragView != null) {
            if (animateBack) {
                this.dragView.startAnimatingRejectedDrag();
            } else {
                this.dragView.stopDragging();
            }
        }
    }

    public View destinationView() {
        return this.destinationView;
    }

    public Rect destinationBounds() {
        if (this.destinationView == null) {
            return null;
        }
        Rect bounds = this.absoluteBounds();
        this.rootView.convertRectToView(this.destinationView, bounds, bounds);
        return bounds;
    }

    public Rect absoluteBounds() {
        Rect rect = new Rect(0, 0, this.image.width(), this.image.height());
        if (this.dragView != null) {
            this.dragView.convertRectToView(null, rect, rect);
        }
        return rect;
    }

    public Point absoluteMousePoint() {
        if (this.dragView != null) {
            Point point = new Point(this.dragView._lastX, this.dragView._lastY);
            this.dragView.superview().convertPointToView(null, point, point);
            return point;
        }
        return new Point(0, 0);
    }

    public Point destinationMousePoint() {
        if (this.destinationView == null) {
            return null;
        }
        if (this.dragView != null) {
            Point point = new Point(this.dragView._lastX, this.dragView._lastY);
            this.dragView.superview().convertPointToView(this.destinationView, point, point);
            return point;
        }
        return new Point(0, 0);
    }

    public boolean destinationIsAccepting() {
        return this.isAccepting;
    }
}

