/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Image;
import java.awt.image.ImageObserver;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Target;

class BitmapObserver
implements ImageObserver {
    Application application;
    Bitmap bitmap;
    int lastInfo;

    BitmapObserver(Application application, Bitmap bitmap) {
        this.application = application;
        this.bitmap = bitmap;
    }

    public synchronized boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
        Target updateTarget;
        this.lastInfo = infoflags;
        if (image == null) {
            return true;
        }
        if ((infoflags & 1) != 0 || (infoflags & 2) != 0 || (infoflags & 4) != 0 || (infoflags & 0x20) != 0 || (infoflags & 0x40) != 0 || (infoflags & 0x80) != 0) {
            this.notifyAll();
            return true;
        }
        if (!this.bitmap.loadsIncrementally()) {
            return true;
        }
        if ((infoflags & 8) != 0) {
            this.bitmap.unionWithUpdateRect(x, y, width, height);
            Target updateTarget2 = this.bitmap.updateTarget();
            if (updateTarget2 != null && this.application != null) {
                this.application.performCommandLater(updateTarget2, this.bitmap.updateCommand(), this.bitmap, true);
            }
        } else if ((infoflags & 0x10) != 0 && (updateTarget = this.bitmap.updateTarget()) != null && this.application != null) {
            this.application.performCommandLater(updateTarget, this.bitmap.updateCommand(), this.bitmap, true);
        }
        return true;
    }

    synchronized boolean allBitsPresent() {
        return (this.lastInfo & 0x20) != 0;
    }

    synchronized boolean imageHasProblem() {
        return (this.lastInfo & 0x40) != 0 || (this.lastInfo & 0x80) != 0;
    }
}

