/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeEncoder;

public final class MimeBase64Decoder
extends MimeEncoder {
    private byte[] token = new byte[4];
    private byte[] bytes = new byte[3];
    private int token_length;
    private static final byte NUL = 127;
    private static final byte EOF = 126;
    private static final byte[] map = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 126, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};

    private final void decode_token(ByteBuf out) {
        int num = map[this.token[0]] << 18 | map[this.token[1]] << 12 | map[this.token[2]] << 6 | map[this.token[3]];
        this.bytes[0] = (byte)(0xFF & num >> 16);
        this.bytes[1] = (byte)(0xFF & num >> 8);
        this.bytes[2] = (byte)(0xFF & num);
        out.append(this.bytes);
    }

    private final void decode_final_token(ByteBuf out) {
        byte b0 = map[this.token[0]];
        byte b1 = map[this.token[1]];
        byte b2 = map[this.token[2]];
        byte b3 = map[this.token[3]];
        int eq_count = 0;
        if (b0 == 126) {
            b0 = 0;
            ++eq_count;
        }
        if (b1 == 126) {
            b1 = 0;
            ++eq_count;
        }
        if (b2 == 126) {
            b2 = 0;
            ++eq_count;
        }
        if (b3 == 126) {
            b3 = 0;
            ++eq_count;
        }
        int num = b0 << 18 | b1 << 12 | b2 << 6 | b3;
        out.append((byte)(num >> 16));
        if (eq_count <= 1) {
            out.append((byte)(num >> 8 & 0xFF));
            if (eq_count == 0) {
                out.append((byte)(num & 0xFF));
            }
        }
    }

    public final void translate(ByteBuf in, ByteBuf out) {
        if (this.token == null) {
            return;
        }
        byte[] inb = in.toBytes();
        int in_length = in.length();
        int i = 0;
        while (i < in_length) {
            byte b = inb[i];
            int x = b & 0xFF;
            byte t = map[x];
            if (t != 127) {
                this.token[this.token_length++] = b;
            }
            if (t == 126) {
                this.eof(out);
                return;
            }
            if (this.token_length == 4) {
                this.decode_token(out);
                this.token_length = 0;
            }
            ++i;
        }
    }

    public final void eof(ByteBuf out) {
        if (this.token != null && this.token_length != 0) {
            while (this.token_length < 4) {
                this.token[this.token_length++] = 61;
            }
            this.decode_final_token(out);
        }
        this.token_length = 0;
        this.token = null;
        this.bytes = null;
    }
}

