/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchemaElement;

public class LDAPSchema {
    private Hashtable objectClasses = new Hashtable();
    private Hashtable attributes = new Hashtable();
    private Hashtable matchingRules = new Hashtable();
    String entryName;

    public void addObjectClass(LDAPObjectClassSchema objectSchema) {
        this.objectClasses.put(objectSchema.getName().toLowerCase(), objectSchema);
    }

    public void addAttribute(LDAPAttributeSchema attrSchema) {
        this.attributes.put(attrSchema.getName().toLowerCase(), attrSchema);
    }

    public void addMatchingRule(LDAPMatchingRuleSchema matchSchema) {
        this.matchingRules.put(matchSchema.getName().toLowerCase(), matchSchema);
    }

    public Enumeration getObjectClasses() {
        return this.objectClasses.elements();
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public Enumeration getMatchingRules() {
        return this.matchingRules.elements();
    }

    public LDAPObjectClassSchema getObjectClass(String name) {
        return (LDAPObjectClassSchema)this.objectClasses.get(name.toLowerCase());
    }

    public LDAPAttributeSchema getAttribute(String name) {
        return (LDAPAttributeSchema)this.attributes.get(name.toLowerCase());
    }

    public LDAPMatchingRuleSchema getMatchingRule(String name) {
        return (LDAPMatchingRuleSchema)this.matchingRules.get(name.toLowerCase());
    }

    public Enumeration getObjectClassNames() {
        return this.objectClasses.keys();
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration getMatchingRuleNames() {
        return this.matchingRules.keys();
    }

    public void fetchSchema(LDAPConnection ld) throws LDAPException {
        LDAPMatchingRuleSchema sch;
        LDAPSchemaElement sch2;
        Enumeration en;
        if (ld == null || !ld.isConnected()) {
            throw new LDAPException("No connection", 80);
        }
        LDAPEntry entry = ld.read("");
        if (entry == null) {
            throw new LDAPException("", 32);
        }
        LDAPAttribute attr = entry.getAttribute("subschemasubentry");
        this.entryName = "cn=schema";
        if (attr != null && (en = attr.getStringValues()).hasMoreElements()) {
            this.entryName = (String)en.nextElement();
        }
        if ((attr = (entry = ld.read(this.entryName)).getAttribute("objectclasses")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPObjectClassSchema((String)en.nextElement());
                this.addObjectClass((LDAPObjectClassSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("attributetypes")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPAttributeSchema((String)en.nextElement());
                this.addAttribute((LDAPAttributeSchema)sch2);
            }
        }
        Hashtable<String, String> h = new Hashtable<String, String>();
        attr = entry.getAttribute("matchingruleuse");
        if (attr != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                String use = (String)en.nextElement();
                sch = new LDAPMatchingRuleSchema(null, use);
                h.put(sch.getOID(), use);
            }
        }
        if ((attr = entry.getAttribute("matchingrule")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                String raw = (String)en.nextElement();
                sch = new LDAPMatchingRuleSchema(raw, null);
                String use = (String)h.get(sch.getOID());
                if (use != null) {
                    sch = new LDAPMatchingRuleSchema(raw, use);
                }
                this.addMatchingRule(sch);
            }
        }
    }

    public String toString() {
        String s = "Object classes: ";
        Enumeration en = this.getObjectClasses();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + (String)en.nextElement();
            s = String.valueOf(s) + ' ';
        }
        s = String.valueOf(s) + "Attributes: ";
        en = this.getAttributes();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + (String)en.nextElement();
            s = String.valueOf(s) + ' ';
        }
        s = String.valueOf(s) + "Matching rules: ";
        en = this.getMatchingRules();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + (String)en.nextElement();
            s = String.valueOf(s) + ' ';
        }
        return s;
    }

    private static void printEnum(Enumeration en) {
        while (en.hasMoreElements()) {
            LDAPSchemaElement s = (LDAPSchemaElement)en.nextElement();
            System.out.println("  " + s);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: netscape.ldap.LDAPSchema HOST PORT");
            System.exit(1);
        }
        int port = Integer.parseInt(args[1]);
        LDAPConnection ld = new LDAPConnection();
        try {
            ld.connect(args[0], port);
            LDAPSchema schema = new LDAPSchema();
            schema.fetchSchema(ld);
            ld.disconnect();
            System.out.println("Object classes: ");
            LDAPSchema.printEnum(schema.getObjectClasses());
            System.out.println("\nAttributes: ");
            LDAPSchema.printEnum(schema.getAttributes());
            System.out.println("\nMatching rules: ");
            LDAPSchema.printEnum(schema.getMatchingRules());
            System.exit(0);
            return;
        }
        catch (LDAPException e) {
            System.err.println(e);
            return;
        }
    }
}

