/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import netscape.ldap.LDAPException;

class LDAPSSLavaSocket
extends Socket {
    private final boolean m_debug = true;
    private Object m_socket;
    private final String m_packageName = "crysec.SSL.SSLSocket";
    private Hashtable m_methodLookup = new Hashtable();

    public LDAPSSLavaSocket(String host, int port, Object cipherSuites) throws LDAPException {
        try {
            Class<?> c = Class.forName("crysec.SSL.SSLSocket");
            Constructor<?>[] m = c.getConstructors();
            int i = 0;
            while (i < m.length) {
                Class<?>[] params = m[i].getParameterTypes();
                if (cipherSuites == null) {
                    throw new LDAPException("Cipher Suites is required");
                }
                if (params.length == 3 && params[0].getName().equals("java.lang.String") && params[1].getName().equals("int") && params[2].getName().equals("crysec.SSL.SSLParams")) {
                    Object[] args = new Object[]{host, new Integer(port), cipherSuites};
                    this.m_socket = m[i].newInstance(args);
                    return;
                }
                ++i;
            }
            throw new LDAPException("No appropriate constructor in crysec.SSL.SSLSocket", 89);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class crysec.SSL.SSLSocket not found", 80);
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    public InputStream getInputStream() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getInputStream", null);
            return (InputStream)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getOutputStream", null);
            return (OutputStream)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    public void close() throws IOException {
        try {
            this.invokeMethod(this.m_socket, "close", null);
            return;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return;
        }
    }

    public void close(boolean wait) throws IOException {
        try {
            Object[] args = new Object[]{new Boolean(wait)};
            this.invokeMethod(this.m_socket, "close", args);
            return;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return;
        }
    }

    public InetAddress getInetAddress() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getInetAddress", null);
            return (InetAddress)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    public int getLocalPort() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getLocalPort", null);
            return (Integer)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return -1;
        }
    }

    public int getPort() {
        try {
            Object obj = this.invokeMethod(this.m_socket, "getPort", null);
            return (Integer)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return -1;
        }
    }

    private Object invokeMethod(Object obj, String name, Object[] args) throws LDAPException {
        try {
            Method m = this.getMethod(name);
            if (m != null) {
                return m.invoke(obj, args);
            }
        }
        catch (Exception e) {
            throw new LDAPException("Invoking " + name + ": " + e.toString(), 89);
        }
        return null;
    }

    private Method getMethod(String name) throws LDAPException {
        try {
            Method method = null;
            method = (Method)this.m_methodLookup.get(name);
            if (method != null) {
                return method;
            }
            Class<?> c = Class.forName("crysec.SSL.SSLSocket");
            Method[] m = c.getMethods();
            int i = 0;
            while (i < m.length) {
                if (m[i].getName().equals(name)) {
                    this.m_methodLookup.put(name, m[i]);
                    return m[i];
                }
                ++i;
            }
            throw new LDAPException("Method " + name + " not found in " + "crysec.SSL.SSLSocket");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class crysec.SSL.SSLSocket not found");
        }
    }

    private void printDebug(String msg) {
        System.out.println(msg);
    }
}

