/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import netscape.ldap.ber.stream.BERSequence;

public class LDAPControl
implements Cloneable {
    public static final String MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    public static final String SORTRESPONSE = "1.2.840.113556.1.4.474";
    public static final String PERSISTENTSEARCH = "2.16.840.1.113730.3.4.3";
    public static final String PWEXPIRED = "2.16.840.1.113730.3.4.4";
    public static final String PWEXPIRING = "2.16.840.1.113730.3.4.5";
    public static final String ENTRYCHANGED = "2.16.840.1.113730.3.4.7";
    private String m_oid;
    protected boolean m_critical = false;
    protected byte[] m_value;

    public LDAPControl() {
    }

    public LDAPControl(String id, boolean critical, byte[] vals) {
        this.m_oid = id;
        this.m_critical = critical;
        this.m_value = vals;
    }

    public String getID() {
        return this.m_oid;
    }

    public boolean isCritical() {
        return this.m_critical;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public Object clone() {
        byte[] vals = null;
        if (this.m_value != null) {
            vals = new byte[this.m_value.length];
            int i = 0;
            while (i < this.m_value.length) {
                vals[i] = this.m_value[i];
                ++i;
            }
        }
        LDAPControl control = new LDAPControl(this.m_oid, this.m_critical, vals);
        return control;
    }

    protected byte[] flattenBER(BERSequence ber) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            ber.write(outStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return outStream.toByteArray();
    }
}

