/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import netscape.plugin.composer.io.FooStringBuffer;
import netscape.plugin.composer.io.Token;

public class Comment
extends Token {
    String text;
    private static final String SELECTION_START = new String("-- selection start --");
    private static final String SELECTION_END = new String("-- selection end --");
    private static final String SELECTION_START_PLUS = new String("-- selection start+ --");
    private static final String SELECTION_END_PLUS = new String("-- selection end+ --");

    public Comment(StringBuffer buf) {
        this.text = buf.toString();
    }

    Comment(FooStringBuffer buf) {
        this.text = buf.toString();
    }

    public Comment(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "<!" + this.text + ">";
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof Comment) {
            return this.text.equals(((Comment)other).text);
        }
        return false;
    }

    public static Comment createSelectionStart() {
        return Comment.createSelectionStart(false);
    }

    public static Comment createSelectionStart(boolean stickyAfter) {
        return new Comment(stickyAfter ? SELECTION_START_PLUS : SELECTION_START);
    }

    public static Comment createSelectionEnd() {
        return Comment.createSelectionEnd(false);
    }

    public static Comment createSelectionEnd(boolean stickyAfter) {
        return new Comment(stickyAfter ? SELECTION_END_PLUS : SELECTION_END);
    }

    public boolean isSelection() {
        return this.isSelectionStart() || this.isSelectionEnd();
    }

    public boolean isSelectionStart() {
        return this.text.equals(SELECTION_START) || this.text.equals(SELECTION_START_PLUS);
    }

    public boolean isSelectionEnd() {
        return this.text.equals(SELECTION_END) || this.text.equals(SELECTION_END_PLUS);
    }

    public boolean isSelectionStickyAfter() {
        return this.text.equals(SELECTION_START_PLUS) || this.text.equals(SELECTION_END_PLUS);
    }
}

