/*
 * dstore.c - Digital UNIX (DEC OSF/1) global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.3 97/07/02 11:21:13 abe Exp $";
#endif


#include "lsof.h"


struct clone *Clone = NULL;
dev_t Clonedev = -1;			/* clone device number */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {
        { "cldev",	"clonedev"	},
        { "fids",	"fids"		},
	{ X_NCACHE,	"namecache"	},
	{ X_NCSIZE,	"nchsize"	},
        { "vnmaxp",	"vn_maxprivate"	},

#if	DUV<30000
        { "proc",	"proc"		},
        { "nproc",	"nproc"		},
#else	/* DUV>=30000 */
        { "npid",	"npid"		},
        { "pidt",	"pidtab"	},
#endif	/* DUV<30000 */

	{ "",		"",		},
	{ NULL,		NULL,		}
};

struct file *Fileptr;			/* for process_file() in lib/prfp. */
int Kd = -1;
struct l_vfs *Lvfs = NULL;

# if    DUV>=30000
KA_T *Pa = NULL;			/* kernel proc structure addresses */
# endif /* DUV>=30000 */

struct proc *Ps = NULL;			/* local proc structures */
int Psn = 0;				/* entries in Paddr[] and Ps[] */
int Vnmxp;				/* vnode's max private area length */
