#!/usr/bin/env python
"""
  install.py - simple installer for use with Install conduit
  $Id: install.py,v 1.5 1998/08/29 01:09:02 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  A simple command-line installer, this utility merely configures the
  Install conduit and uses its install() method to copy the specified
  files to the spool directory.
"""

__version__ = '$Id: install.py,v 1.5 1998/08/29 01:09:02 rob Exp $'

import sys, os

import PDA.Palm
import PDA.Palm.Config
import PDA.Palm.Conduit.Install

def install_files(files, user=None):
    r = PDA.Palm.Conduit.Install.install_files(files, user)

    if filter(None, r):
	for f, e in map(None, files, r):
	    sys.stderr.write('Error installing %s.\n' % f)
    else:
	sys.stderr.write('All files installed successfully.\n')

def tk_install(user=None):
    from PDA.Palm.Tk.DBFileDialog import askDBFile
    import Tkinter

    w = Tkinter.Tk()
    Tkinter.Label(w,text='PDB Installer').grid(row=0,column=0,sticky='ew')
    Tkinter.Label(w,text='by Rob Tillotson <rob@io.com>').grid(row=1,column=0,
							       sticky='ew')
    
    a = askDBFile(w)
    if a:
	install_files(a, user)
    else:
	sys.stdout.write('No files selected.\n')
	
if __name__ == '__main__':
    import getopt

    optlist, args = getopt.getopt(sys.argv[1:], 'u:h')

    user = None
    
    for a, v in optlist:
	if a == '-u':
	    user = v
	if a == '-h':
	    print "Usage: %s [-u <username>] <file> [<file> ...]" % sys.argv[0]
	    sys.exit(0)

    if args:
	install_files(args, user)
    else:
	tk_install(user)

