#!/usr/bin/env python
#
# Fetch a usa today puzzle from their web site and save it as an xword file
#
#   Copyright 1998 Rob Tillotson <robt@debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU Library General Public License, version 2,
#   as published by the Free Software Foundation.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public License
#   along with this program; if not, write the Free Software Foundation,
#   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#

import PDA.Palm
import PDA.Palm.App.XWord

import urllib

import string, sys, time

usa_today_url = 'http://www.usatoday.com/life/puzzles/'

def fetch(y,m,d):
    if y >= 100: y = y % 100
    puz = 'ut%02d%02d%02d.puz' % (y, m, d)
    pdb = 'ut%02d%02d%02d.pdb' % (y, m, d)
    subdir = '%02d%02d' % (y, m)
    url = usa_today_url + subdir + '/' + puz

    print 'Getting ', url
    u = urllib.urlopen(url)
    f = open(puz, 'w')
    f.write(u.read())
    f.close()
    p = PDA.Palm.App.XWord.Record()
    p.read_usa_today(open(puz))

    if len(p['name']) > 31: n = p['name'][:31]
    else: n = p['name']
    f = PDA.Palm.createFile(pdb, {'name': n, 'type':'DATa', 'creator':'XWrd'})
    f.addRecord(p)
    

def fetch_range(y0, m0, d0, y1, m1, d1):
    t0 = int(time.mktime((y0, m0, d0, 0, 0, 0, 0, 0, 0)))
    t1 = int(time.mktime((y1, m1, d1, 0, 0, 0, 0, 0, 0)))

    while t0 <= t1:
	tu = time.gmtime(t0)
	sys.stdout.write('%s ... ' % time.strftime('%A, %B %d, %Y', tu))
	if tu[6] < 5:  # puzzles only on monday through friday
	    fetch(tu[0], tu[1], tu[2])
	    sys.stdout.write('fetched.\n')
	else:
	    sys.stdout.write('no puzzle.\n')
	t0 = t0 + (60*60*24)
	
# Command line arguments:
#   fetchusa [-r <date0>] <date1> ...
#
# If -r is supplied, gets all puzzles frmo <date0> to <date1> inclusive.
# If not, just gets all of the dated puzzles.

def main(args):
    import getopt

    optlist, args = getopt.getopt(args, 'r:')

    startdate = None
    
    for o, v in optlist:
	if o == '-r':
	    startdate = v

    if startdate:
	m0, d0, y0 = tuple(map(string.atoi,string.split(startdate, '/')))
	m, d, y = tuple(map(string.atoi,string.split(args[0], '/')))
	fetch_range(y0, m0, d0, y, m, d)
    else:
	for x in args:
	    m, d, y = string.split(args[0], '/')
	    fetch(y, m, d)
	    

if __name__ == '__main__':
    main(sys.argv[1:])
    
    
