"""
  PDA.Palm.Tk.DBInfoDialog -- Database info viewer/editor(?)
  $Id: DBInfoDialog.py,v 1.3 1998/08/29 01:09:02 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


"""

from Tkinter import *
import tkSimpleDialog

from time import asctime, localtime

class DBInfoDialog(tkSimpleDialog.Dialog):
    def __init__(self, parent, info):
	self.info = info
	tkSimpleDialog.Dialog.__init__(self, parent,
				       'DB Info: %s' % info['name'])

    def body(self, parent):
	i = parent
	info = self.info
	
	Label(i, text='Name:').grid(row=0,column=0,sticky=E)
	Label(i, text=str(info['name'])).grid(row=0,column=1,sticky=W)
	Label(i, text='Type:').grid(row=1,column=0,sticky=E)
	Label(i, text=str(info['type'])).grid(row=1,column=1,sticky=W)
	Label(i, text='Creator:').grid(row=2,column=0,sticky=E)
	Label(i, text=str(info['creator'])).grid(row=2,column=1,sticky=W)
	Label(i, text='Version:').grid(row=3,column=0,sticky=E)
	Label(i, text=str(info['version'])).grid(row=3,column=1,sticky=W)
	Label(i, text='Created:').grid(row=4,column=0,sticky=E)
	Label(i, text=asctime(localtime(info['createDate']))).grid(row=4,
								   column=1,sticky=W)
	Label(i, text='Modified:').grid(row=5,column=0,sticky=E)
	Label(i, text=asctime(localtime(info['modifyDate']))).grid(row=5,
								   column=1,sticky=W)
	Label(i, text='Backed Up:').grid(row=6,column=0,sticky=E)
	Label(i, text=asctime(localtime(info['backupDate']))).grid(row=6,
								   column=1,sticky=W)
	Label(i, text='Resource?').grid(row=7,column=0,sticky=E)
	Label(i, text=(info['flagResource'] and 'Yes' or 'No')).grid(row=7,
								     column=1,sticky=W)
	Label(i, text='Backup?').grid(row=8,column=0,sticky=E)
	Label(i, text=(info['flagBackup'] and 'Yes' or 'No')).grid(row=8,
								   column=1,sticky=W)
	Label(i, text='Read Only?').grid(row=9,column=0,sticky=E)
	Label(i, text=(info['flagReadOnly'] and 'Yes' or 'No')).grid(row=9,
								     column=1,sticky=W)
	Label(i, text='AppInfo Dirty?').grid(row=10,column=0,sticky=E)
	Label(i, text=(info['flagAppInfoDirty'] and 'Yes' or 'No')).grid(row=10,
									 column=1,
									 sticky=W)
	Label(i, text='Exclude from Sync?').grid(row=11,column=0,sticky=E)
	Label(i, text=(info['flagExcludeFromSync']
			       and 'Yes' or 'No')).grid(row=11,column=1,sticky=W)
	Label(i, text='Reset on Install?').grid(row=12,column=0,sticky=E)
	Label(i, text=(info['flagReset'] and 'Yes' or 'No')).grid(row=12,
								  column=1,sticky=W)
	Label(i, text='Newer?').grid(row=13,column=0,sticky=E)
	Label(i, text=(info['flagNewer'] and 'Yes' or 'No')).grid(row=13,
								  column=1,sticky=W)
	Label(i, text='Open?').grid(row=14,column=0,sticky=E)
	Label(i, text=(info['flagOpen'] and 'Yes' or 'No')).grid(row=14,
								 column=1,sticky=W)
	Label(i, text='Modification #:').grid(row=15,column=0,sticky=E)
	Label(i, text=str(info['modnum'])).grid(row=15,column=1,sticky=W)

    def buttonbox(self):
	box = Frame(self)

	w = Button(box, text="OK", width=10, command=self.ok, default=ACTIVE)
	w.grid(row=0, column=0)

	self.bind('<Return>', self.ok)
	self.bind('<Escape>', self.cancel)

	box.pack()
	
