"""
  PDA.Palm.Plugin - Plugin architecture (conduits, etc.)
  $Id: Plugin.py,v 1.2 1998/08/29 01:09:00 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This module defines a standard 'plug in' architecture.  Most of the
  code here used to be in the Conduit class, but was moved here so that
  it would be useful for other sorts of plug-ins, notably import/export
  filters.


"""

__version__ = '$Id: Plugin.py,v 1.2 1998/08/29 01:09:00 rob Exp $'

import sys
# fix this
import Config
#
import Options


class Plugin:
    """
    Superclass for all plug-ins.
    """
    def __init__(self):
	self.logfile = sys.stdout

	self.name = ''
	self.author = ''
	self.description = ''
	self.version = ''
	self.url = ''

	self.type = ''
	self.properties = []
	
	self.options = {}
	self.registry = None

    def __repr__(self):
	return '<Plugin: %s: %s>' % (self.type, self.name)

    __str__ = __repr__
    
    def log(self, str):
	"""Write a string to the log file.
	"""
	self.logfile.write('%s: %s\n' % (self.name, str))

    def define_options(self, options):
	"""Define plug-in options; for internal use.
	"""
	for x in options:
	    if isinstance(x, Options.Option):
		self.options[x.name] = x

    #
    # Overload __setattr__ and __getattr__ to transparently treat options
    # like instance attributes
    #
    def __getattr__(self, k):
	if self.__dict__.has_key('options') and self.options.has_key(k):
	    return self.options[k].value

    def __setattr__(self, k, v):
	if self.__dict__.has_key('options') and self.__dict__['options'].has_key(k):
	    self.__dict__['options'][k].validate(v)
	    self.__dict__['options'][k].value = v
	else:
	    self.__dict__[k] = v
	    
    def gui_configure(self, parent, *a, **kw):
	"""Pop up a GUI configuration dialog.  Right now this just uses
	the Tk one, but later there will be a way to select a method.
	"""
	# there should also be a way to specify the order things appear
	# in the dialog.
	from PDA.Palm.Tk import ConfigDialog
	apply(ConfigDialog.ConfigDialog, (parent,self.options.values())+a, kw)
	    

    def configure(self, options=None):
	"""Set plug-in options.  The optional parameter is either a
	dictionary (containing option values, keyed by name) or a
	Registry object; if either is supplied, the conduit will be
	configured from that data.  If no parameter is supplied, the
	current option values will be returned as a dictionary.
	"""
	if options is None:
	    d = {}
	    for k in self.options.values():
		d[k.name] = k.value
	elif isinstance(options, Config.Registry):
	    self.registry = options
	    for k in self.options.values():
		if self.registry.has_key('PalmPython',
					 '%s.%s.%s' % (self.type, self.name, k.name)):
		    v = options.get('PalmPython',
				    '%s.%s.%s' % (self.type, self.name, k.name))
		    try:
			k.from_str(v)
		    except Options.ValidationError:
			k.value = k.default
		else:
		    k.value = k.default
	else:
	    for k in self.options.values():
		if options.has_key(k.name):
		    try:
			k.validate(options[k.name])
		    except Options.ValidationError:
			k.value = k.default
		    else:
			k.value = options[k.name]
		else:
		    k.value = k.default


    def has_property(self, prop):
	"""Test whether this plug-in has the named property.
	"""
	return prop in self.properties
    
