"""
  PDA.Palm.Conduit.TimeSync - Synchronizes the Palm's clock to the desktop
  $Id: TimeSync.py,v 1.4 1998/08/29 01:09:01 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This small conduit simply sets the PalmOS device's clock to be the
  same as the one on the desktop.  This is obviously most useful if
  the desktop clock is, in turn, synchronized to an accurate source
  locally or via NTP.  (Otherwise, the PalmOS device is probably the more
  accurate of the two!)

"""

import PDA.Palm
import PDA.Palm.Conduit

import time

class Conduit(PDA.Palm.Conduit.Conduit):
    def __init__(self):
	PDA.Palm.Conduit.Conduit.__init__(self)

	self.name = 'TimeSync'
	self.version = '0.1'
	self.author = 'Rob Tillotson <rob@io.com>'
	self.url = ''
	self.description = 'Synchronizes the clocks on the PalmOS device and desktop.'

    def __call__(self, dlp, username):
	self.log('PalmOS clock: %s' % time.ctime(dlp.getTime()))
	t = int(time.time())
	dlp.setTime(t)
	self.log('set to: %s' % time.ctime(t))
	
