"""
  PDA.Palm.App.Memo - Memo Pad
  $Id: Memo.py,v 1.4 1998/08/29 01:09:01 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This module handles databases in the format used by the built-in
  Memopad application.
"""

__version__ = '$Id: Memo.py,v 1.4 1998/08/29 01:09:01 rob Exp $'

import PDA.Palm
from PDA.Palm import _pdapalm, FLD_STRING

class Record(PDA.Palm.Record):
    def __init__(self, raw=None, index=None, id=None, attr=0, category=None):
	self.fields = {'text': (FLD_STRING, '')}
	PDA.Palm.Record.__init__(self, raw, index, id, attr, category)

    def unpack(self, raw):
	self.raw = raw
	_pdapalm.MemoUnpack(self.data, raw)

    def pack(self):
	self.raw = _pdapalm.MemoPack(self.data)
	return self.raw

class AppBlock(PDA.Palm.AppBlock):
    def __init__(self, raw=None):
	PDA.Palm.AppBlock.__init__(self, raw)

    def unpack(self, raw):
	self.raw = raw
	_pdapalm.MemoUnpackAppBlock(self.data, raw)

    def pack(self):
	self.raw = _pdapalm.MemoPackAppBlock(self.data)
	return self.raw

class Database(PDA.Palm.Database):
    def __init__(self, db, info):
	PDA.Palm.Database.__init__(self, db, info)
	self.record_class = Record
	self.appblock_class = AppBlock

PDA.Palm.Types.register(Database, {'type': 'DATA', 'creator': 'memo'})


