
/* 
 * functions - functions available at the module level
 * $Id: functions.c,v 1.3 1997/08/28 10:08:01 leonard Exp $
 */

#include "common.h"
#include "functions.h"
#include "LDAPObject.h"
#include "errors.h"

/* ldap_open */

static PyObject*
l_ldap_open( PyObject* unused, PyObject *args )
{
    char *host;
    int port = LDAP_PORT;
    LDAP *ld;

    if (!PyArg_ParseTuple( args, "s|i", &host, &port )) return NULL;
    Py_BEGIN_ALLOW_THREADS
    ld = ldap_open(host, port);
    Py_END_ALLOW_THREADS
    if (ld == NULL) return LDAPerror(ld,"ldap_open");
    return (PyObject*) newLDAPObject( ld );
}

/* ldap_dn2ufn */

static PyObject*
l_ldap_dn2ufn( PyObject* unused, PyObject *args )
{
    char *dn;
    char *ufn;
    PyObject *result;

    if (!PyArg_ParseTuple( args, "s", &dn )) return NULL;

    ufn = ldap_dn2ufn(dn);
    if (ufn == NULL) {
    	PyErr_NoMemory();
	return NULL;
    }
    result = PyString_FromString( ufn );
    free(ufn);
    return result;
}

/* ldap_explode_dn */

static PyObject*
l_ldap_explode_dn( PyObject* unused, PyObject *args )
{
    char *dn;
    int notypes = 0;
    char **exploded;
    PyObject *result;
    int i;

    if (!PyArg_ParseTuple( args, "s|i", &dn, &notypes )) return NULL;

    exploded = ldap_explode_dn(dn, notypes);

    if (exploded == NULL) 
    	return LDAPerror(NULL,"ldap_explode_dn");

    result = PyList_New(0);
    for(i=0; exploded[i]; i++)
    	PyList_Append( result, PyString_FromString( exploded[i] ) );

    ldap_value_free(exploded);
    return result;
}

/* ldap_is_ldap_url */

static PyObject*
l_ldap_is_ldap_url( PyObject* unused, PyObject *args )
{
    char *url;

    if (!PyArg_ParseTuple( args, "s", &url )) return NULL;
    return PyInt_FromLong( ldap_is_ldap_url( url ));
}

/* methods */

static PyMethodDef methods[] = {
    { "open",		(PyCFunction)l_ldap_open,		METH_VARARGS },
    { "dn2ufn",		(PyCFunction)l_ldap_dn2ufn,		METH_VARARGS },
    { "explode_dn",	(PyCFunction)l_ldap_explode_dn,		METH_VARARGS },
    { "is_ldap_url",	(PyCFunction)l_ldap_is_ldap_url,	METH_VARARGS },
    { NULL, NULL }
};

/* initialisation */

void
LDAPinit_functions( PyObject* d ) {
    LDAPadd_methods( d, methods );
}
