.\" @(#)mknbi-linux.8
.\"
.\" Copyright (C) 1995,1998 Gero Kuhlmann   <gero@gkminix.han.de>
.\" Copyright (C) 1996,1997 Gero Kuhlmann   <gero@gkminix.han.de>
.\"                and Markus Gutschke <gutschk@math.uni-muenster.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH MKNBI-LINUX 8 "11 May 1998"
.SH NAME
mknbi\-linux \- MaKe NetBoot Image for Linux

.SH SYNOPSIS
.LP
.B mknbi-linux
[OPTIONS] [<kernel image> [<output file>]]

.SH DESCRIPTION
.B mknbi-linux
is a program to convert a
.SM Linux
kernel image into a file suitable for loading by diskless
systems using a
.SM Bootrom.

.SH OPTIONS
.TP
.B \-a, \-\-append STRING
String to append to the end of the kernel command line.
.TP
.B \-b, \-\-batch-sys SYS
Lets
.B mknbi\-linux
operate in batch mode. It will look up the given system name in a
database file and generate a netbootable image according to the
parameters given in the database entry. If this option is not
given,
.B mknbi\-linux
will operate according to the other command line options. If giving
any other options in addition to
.B \-b
or
.BR \-\-batch-sys ,
the parameters found in the database will override those processed from
the command line.
.TP
.B \-C, \-\-config-file FILE
Specifies a configuration file.
.TP
.B \-d, \-\-root-dir STRING
Define name of directory to mount via NFS from the boot server.
If
.B rom
is given, that directory is used as root in which the loaded netboot
image file is located. This is determined by the
.SM Bootrom
at run time, usually by using the BOOTP-Protocol.
If the BOOTP Server is able to handle the RFC 1497 extensions,
it is possible to define a different root directory. With
.B kernel
the directory name is the default name used by the kernel.
Giving
.B ram
the kernel will use a ramdisk for booting, and no NFS directory will
be mounted. Also if the name given to the
.B \-d
or
.B \-\-root-dir
option starts with "/dev/", the corresponding device is used as the
root device, and no NFS directory will be mounted. The default for
this option is
.IR /tftpboot/%s ,
with the
.B "%s"
representing the IP-Number of the booting system.
.TP
.B \-h, \-\-help
Print short usage information.
.TP
.B \-i, \-\-ip-addrs STRING
Define client and server IP addresses. If
.B rom
is given as the argument to this option, all necessary IP
addresses for NFS root mounting will be determined at runtime
using the BOOTP answer the
.SM Bootrom
got from the server. This is the prefered value when using
.B mknbi-linux
together with a Bootrom.
.LP
.RS
With
.B kernel
no IP addresses are defined, and the kernel should determine them
by itself, usually by using RARP or BOOTP. If the
.B \-i
or
.B \-\-ip-addrs
option is missing this is the default.
.LP
It's also possible to define the addresses
during compilation of the boot image. Then, all addresses must be
seperated by a colon, and ordered in the following way:
.LP
client:server:gateway:netmask:hostname[:dev]
.LP
Using this option
.B mknbi-linux
will automatically convert system names into decimal IP addresses for
the first four entries in this string. The
.B hostname
entry will be used
by the kernel to set the host name of the booted Linux diskless client.
When more than one network interface are installed in the diskless client,
it is possible to specify the name of the interface to use for mounting
the root directory via NFS by giving the optional value
.BR dev .
This entry has to start with the string
.B eth
followed by a number from 0 to 9. However, if only one interface is
installed in the client, this
.B dev
entry including the preceding semicolon can be left out.
.RE
.TP
.B \-k, \-\-kernel FILE
Pathname of kernel image file. The default is
.IR /vmlinuz .
.TP
.B \-l, \-\-ramdisk-mode
The startup code that will be include in the netboot image, can
usually take care of moving the ramdisk image to a valid location in
memory. But depending on the version of your BIOS, the kind of
Bootrom you use, and the fact that you might have more than 16MB of
memory, there could be difficulties. In this case, you will have to
provide further information:
.RS
.TP
.B auto
This is the default behavior. The Bootrom will load the ramdisk
image at address 0x100000 (if the kernel is already loaded there, the
ramdisk image will be moved right behind the kernel image). The
startup code will then try to determine the last legal address in the
lower 16MB and subsequently move the ramdisk image there. This
technique will work in most cases and provides the highest degree of
compatibility and portability among different machines.
.TP
.B eom
If
.B auto
does not work for you, you should check if your Bootrom is capable
of loading the ramdisk image to the end of the physical memory. This
might work fine, but it is slightly less compatible than
.BR auto .
.TP
.B <address>
If everything else fails, you can resort to explicitly specifying the
load address. Although beware that this is likely to cause problems,
when trying to use the same image on machines with different amounts
of memory. You should try to specify an address that is both below
16MB and below the physical end of memory; you will have to leave
enough room for the entire (compressed) ramdisk image. If you move the
image too low, it will collide with the uncompressed kernel image and
the kernel will ignore the contents of the ramdisk; you will notice a
warning message, when booting. If you have at least 16MB of main
memory, you should try to load the image to
.BR 0xD30000 ,
as this leaves enough room for an uncompressed 2.88MB ramdisk image,
but is unlikely to conflict with the uncompressed kernel image. If you
want to see if there is a conflict between the ramdisk image and
other parts of the compiled netboot image, you can increase the
verbosity level until detailed load record information is printed.
.RE
.TP
.B \-N, \-\-netboot-dir DIR
Specifies the path of the main netboot directory.
.TP
.B \-o, \-\-outfile FILE
Pathname of output file, which is lateron loaded by the
.SM Bootrom
via
.SM tftp.
.TP
.B \-r, \-\-ramdisk-image DIR|FILE
Preloaded ramdisk image; for further information look into
.I linux/Documentation/initrd.txt
in the Linux source tree. This requires Linux V1.3.73 or above.
.TP
.B \-s, \-\-cmdl-size SIZE
Maximum size of command line. This parameter specifies how much
memory the boot loader should reserve for assembling the kernel
command line. It is useful if you have a very long kernel command
line, for example by using the
.B \-a
option. If the kernel command line is longer then the number of bytes
specified, it gets truncated automatically.
The lowest usable value for this parameter is 2048, which is also the
default. Use
.B \-s
or
.B \-\-cmdl-size
only if you know what you are doing because it can scramble the
memory layout of the boot loader.
.TP
.B \-v, \-\-version
Print version information.
.TP
.B \-x, \-\-verbose
Verbose output to let you know what
.B mknbi-linux
is doing. Each
.B \-x
increases the verbosity level.

.SH BOOTP VENDOR TAGS
.B mknbi-linux
includes a startup code at the beginning of the Linux kernel which is able
to detect certain BOOTP vendor defined tags. These can be used to modify
the kernel loading process at runtime. To use these tags with bootpd, a
publicly available BOOTP server daemon, you can use the following syntax
in the /etc/bootptab file:
.RS
.LP
T<number>="<string>"
.LP
.RE
For example, to specify a different root NFS device, you can use:
.RS
.LP
T130="eth1"
.LP
.RE
The following tags are presently supported by
.BR mknbi-linux :
.TP
.B 129
The
.B <string>
value given with this tag is appended verbatim to the end of the
kernel command line.
It can be used to specify arguments like I/O addresses or DMA channels
required for special hardware like SCSI adapters, network cards etc. Please
consult the Linux kernel documentation about the syntax required by those
options. It is the same as the
.B \-a
or
.B \-\-append
command line option to
.BR mknbi\-linux ,
but works at runtime instead of compile time.
.TP
.B 130
With this tag it is possible to the select the network adapter used for
mounting root via NFS on a multihomed diskless client. The syntax for
the
.B <string>
value is the same as for the
.B dev
entry used with the
.B \-i
option as described above. However note that the
.B mknbi-linux
runtime loader does not check the syntax of the string.

.SH DATABASE FILE
.B mknbi\-linux
does not use any sections in the configuration file except the [general]
section. However, for easier maintenance of different client configurations
the database file can be used. The entries have to be preceded by a
[<system name>:mknbi-linux] tag and can contain the following parameters:
.TP
.B outfile
Specifies the name of the output file
.TP
.B ramdisk-image
Specifies the name of the ramdisk image file or directory
.TP
.B ramdisk-size
Specifies the size of the ramdisk. This parameter works like the
.B \-s
or
.B \-\-ramdisk-size
command line arguments. The ramdisk size gets therefore determined in
the same way as described above.
.TP
.B append
Adds a string verbatim at the end of the Linux kernel command line.
.TP
.B skip-check
This boolean parameter specifies wether to skip certain compatibility
checks.
.TP
.B no-hard-disk
Boolean parameter which specifies if to allow hard disk accesses in the
client or not.
.TP
.B simulate-hd
This boolean parameter allows the ramdisk to simulate a hard disk in the
client.

.SH BUGS
None known yet

.SH SEE ALSO
netboot.config(5)

.SH AUTHOR
.B mknbi-linux
was written by
.SM Gero Kuhlmann <gero@gkminix.han.de>.
Support for preloaded ramdisks and loading into extended memory has
been added by
.SM Markus Gutschke <gutschk@uni-muenster.de>.

