/*
 * romcheck.h  -  General definitions for romcheck
 *
 * Copyright (C) 1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * Some generally useful definitions
 */
#ifndef FALSE
# define FALSE	0
#endif
#ifndef TRUE
# define TRUE	1
#endif



/*
 * Memory layout
 */
#define STARTSEG	0xC000		/* First segment in memory scan */
#define ENDSEG		0xF000		/* Last segment in memory scan */
#define VIDEOSEG	0xC000		/* Usual place for video BIOS */



/*
 * Structure holding the result of the memory scan.
 */
#ifndef IN_ASM_MODULE
struct scaninfo {
	unsigned short  signum;		/* Number of signatures found */
	unsigned short *sigsegs;	/* Segments of rom signatures */
	unsigned short *sigsize;	/* Size of roms according to sigs */
	unsigned short *sigvalid;	/* Buffer indicating valid checksums */

	unsigned short  nbindex;	/* Index to netboot signature area */
	unsigned char   nbmajor;	/* Netboot rom major version */
	unsigned char   nbminor;	/* Netboot rom minor version */

	unsigned short  romsize;	/* Size of rom buffer */
	unsigned char  *rombuf;		/* Buffer holding id for each rom seg */

	unsigned short  flashseg;	/* Segment of FlashCard */
};
#else
! Offsets to each element in structure (for assembler module)

si_signum	equ	 0		! Number of signatures found
si_sigsegs	equ	 2		! Segments of rom signatures
si_sigsize	equ	 4		! Size of roms according to sigs
si_sigvalid	equ	 6		! Buffer indicating valid checksums
si_nbindex	equ	 8		! Index to netboot signature area
si_nbmajor	equ	10		! netboot rom major version
si_nbminor	equ	11		! netboot rom minor version
si_romsize	equ	12		! size of rom buffer
si_rombuf	equ	14		! buffer holding id for each rom seg
si_flashseg	equ	16		! segment of FlashCard
#endif


/* Type IDs for rom segments */
#define TYPE_RAM	0		/* Memory RAM */
#define TYPE_ROM	1		/* Memory is ROM or write-protected */
#define TYPE_UNKNOWN	2		/* Cant determine whether ROM or RAM */
#define TYPE_EMPTY	3		/* Probably empty ROM */



/*
 * Characters used to display the scan result
 */
#define CHAR_DASH	'-'		/* Memory area not used by rom */
#define CHAR_VALID	0xB2		/* Memory area used by rom */
#define CHAR_INVALID	0xB0		/* Memory area has invalid checksum */

#define CHAR_RAM	0x04		/* Segment is RAM */
#define CHAR_ROM	0xB1		/* Segment is ROM or write-protected */
#define CHAR_EMPTY	0xF9		/* Segment is probably empty ROM */
#define CHAR_UNKNOWN	0xFA		/* Cant determine segment type */

#define CHAR_FLASH	'^'		/* Pointer indicating start of flash */



/*
 * External routines
 */
#ifndef IN_ASM_MODULE
/* Routines in module doscan.S */
extern void doscan __P((struct scaninfo *sip));

/* Routines in module printscan.c */
extern void printscan __P((struct scaninfo *sip));

/* Routines in module printhex.c */
extern void printhex __P((struct scaninfo *sip));

/* Routines in module io.c */
extern char waitchar __P((void));
extern int readint __P((char *prompt, int minval, int maxval, int defval));
extern unsigned int readhex __P((char *prompt,
	unsigned int minval, unsigned int maxval, unsigned int defval));
#endif

