/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __SERVERS_H__
#define __SERVERS_H__

#include <glib.h>
#include "bezerk.h"

#define LAG_LEN 10 
#define MODELEN 20

typedef struct _Network {
  char *name;
} Network;

typedef struct _Server {
  char *name;
  struct _Network *network;
  int low_port;
  int high_port;
  int favourite;
  char *descr;
} Server;

typedef struct _Connection
{
  Server *server_ptr;
  unsigned status;
  int sd;
  char *nick;
  char *oldnick;
  char *name;
  char *server;
  int port;
  char mode[MODELEN+1];
  char lag[LAG_LEN];
  union _BezWindow *console;
  union _BezWindow *current_window;
  GSList *channels;
  GSList *messages;

  gint tag; /* GTK I/O tag */
} Connection;

typedef struct _ServerEditData {
  void *user_data;
  GtkWidget *dialog;
  GtkWidget *combo;
  GtkWidget *name;
  GtkWidget *low_port;
  GtkWidget *high_port;
  GtkWidget *fav;
  GtkWidget *descr;
  void (*positive_func)(gchar **, void *);
  void (*negative_func)(void *);
} ServerEditData;

typedef struct _ServersPrefsData {
  GtkWidget *vbox;
  GtkWidget *hbox;  
  GtkWidget *clist;
  guint selected_row;
  guint changed;

  guint network_width;
  guint server_width;
  guint hp_width;
  guint lp_width;
  guint fav_width;
  guint descr_width;
} ServersPrefsData;

typedef struct _ServerFavsData {
  struct _ServersPrefsData *servers_prefs;
  GtkWidget *dialog;
  GtkWidget *clist;
  guint selected_row;
  guint changed;
} ServerFavsData;

#define connection_console(conn)   ((conn) ? ((Connection *)conn)->console : NULL)
#define connection_channels(conn)  ((conn) ? ((Connection *)conn)->channels : NULL)
#define connection_messages(conn)  ((conn) ? ((Connection *)conn)->messages : NULL)

#define SERVERS_FILE "servers"

gint servers_init();
gint servers_add(Network *network, char *server, char *low_port, char *high_port,
		 char *fav, char *descr);
Server *servers_get_fav(int fav_num);
GList *servers_get_fav_list();
Server *servers_find(char *object);
Network *network_add(char *name);
Connection *connection_create(Server *server_ptr, int sd, char *server, int port,
			      union _BezWindow *console);
gint connection_destroy(Connection *connection);
Connection *connection_find_by_sd(int sd);
Connection *connection_find_by_name(char *server_name);
GtkWidget *servers_prefs_create(void **pref_data);
gint servers_prefs_save(void *pref_data);
void servers_prefs_reset(void *pref_data);

#endif /* __SERVERS_H__ */
