#
#  'reports.tcl' -- CBB General Reporting/Graphing Front End
#
#  Written by Curtis Olson.  Started November 17, 1994.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: reports.tcl,v 1.1.1.1 1999/12/18 02:05:29 curt Exp $


#------------------------------------------------------------------------------
# Set defaults 
#------------------------------------------------------------------------------

set report(cur_file) ""
set report(tmp_file) ""
set report(start) ""
set report(end) ""
set report(dest) "screen"
set report(temp) ""


#------------------------------------------------------------------------------
# Create report options window
#------------------------------------------------------------------------------

proc cbbWindow.rep {} {
    global lib_path cbb report max_files files names

    if {[winfo exists .rep] == 1} {
	destroy .rep
    }

    toplevel .rep

    option add *font $cbb(dialog_font)

    if { "$report(type)" == "report" } {
	set name "Report"
    } else {
	set name "Graph"
    }

    if { "$report(dest)" != "screen" } {
        if { "$report(dest)" == "file" } {
	    set report(dest) "screen"
        }
    } 

    wm title .rep "$name Configuration ..."
    wm iconname .rep "$name Configuration ..."
    frame .rep.f -borderwidth 2 -relief raised
    pack .rep.f -side top -fill both -expand 1

    frame .rep.f.l 
    frame .rep.f.r 
    pack .rep.f.l .rep.f.r -side left -fill both -expand 1

    frame .rep.f.l.rep -borderwidth 2 -relief groove
    frame .rep.f.l.file -borderwidth 2 -relief groove
    pack .rep.f.l.rep .rep.f.l.file -side top -fill both -expand 1 \
	    -padx 4 -pady 4

    label .rep.f.l.rep.label -text "Select a $name"
    pack .rep.f.l.rep.label -side top -fill x -expand 1

    set i 0
    if { $report(type) == "report" } {
        set filehandle [open "$lib_path/reports/reports.conf" r]
    } else {
        set filehandle [open "$lib_path/graphs/graphs.conf" r]
    }
	
    while { [gets $filehandle line] >= 0 } {
        if { "[string range $line 0 0]" == "-" } {
	    # ignore this line
        } elseif { "[string range $line 0 0]" == "#" } {
            # ignore this line
        } elseif { [string length $line] < 3  } {
            # ignore this line
        } else {
            set pieces [split $line "\t"]
            set bname [lindex $pieces 0]
            set prog [lindex $pieces 1]
            radiobutton .rep.f.l.rep.rep$i -text $bname -relief flat \
		-variable report(name) -value "$prog"
	    pack .rep.f.l.rep.rep$i -side top -anchor w 

	    if { "$report(name)" == "" } {
		set report(name) "$prog"
	    }
	    set i [expr $i + 1]
        }
    }
    close $filehandle

    label .rep.f.l.file.label -text "Select One or More Files"
    pack .rep.f.l.file.label -side top -fill x -expand 1

    set i 0
    set max_files 0
    # cd [file dirname $report(cur_file)]
    if { $cbb(debug) } { puts $report(cur_file) }
    foreach file [lsort [glob -nocomplain \
	    [file dirname $report(cur_file)]/*.cbb]] {
	set max_files $i
	checkbutton .rep.f.l.file.file$i -text [file tail $file] -relief flat \
		-variable files($i) 

        set files($i) 0
	set names($i) $file
	if { "$file" == "$report(cur_file)" } {
	    set files($i) 1
	    if { "$report(tmp_file)" != "" } {
	        set names($i) $report(tmp_file)
	    } 
	}
	
        pack .rep.f.l.file.file$i -side top -anchor w

	set i [expr $i + 1]
    }

    frame .rep.f.r.conf -borderwidth 2 -relief groove
    frame .rep.f.r.but -borderwidth 2 -relief groove
    pack .rep.f.r.but -side bottom -fill x -padx 4 -pady 4
    pack .rep.f.r.conf -side top -fill x -expand 1 -padx 4 -pady 4 -anchor n

    label .rep.f.r.conf.label2 -text "Enter Starting and Ending dates"
    pack .rep.f.r.conf.label2 -side top -fill x -expand 1

    frame .rep.f.r.conf.s -borderwidth 2
    frame .rep.f.r.conf.e -borderwidth 2
    pack .rep.f.r.conf.s .rep.f.r.conf.e -side top -fill x -expand 1

    if { $report(type) == "report" } {
        frame .rep.f.r.conf.os -borderwidth 2
        frame .rep.f.r.conf.of -borderwidth 2
        frame .rep.f.r.conf.oe -borderwidth 2

        pack .rep.f.r.conf.os .rep.f.r.conf.of .rep.f.r.conf.oe \
	        -side top -fill x -expand 1
    }

    label .rep.f.r.conf.s.label -text "Starting Date"
    set report(start) $cbb(report_sdate)
    entry .rep.f.r.conf.s.entry -textvariable report(start) -relief sunken
    pack .rep.f.r.conf.s.label -side left
    pack .rep.f.r.conf.s.entry -side left -fill x -expand 1

    label .rep.f.r.conf.e.label -text "Ending Date"
    entry .rep.f.r.conf.e.entry -textvariable report(end) -relief sunken
    pack .rep.f.r.conf.e.label -side left
    pack .rep.f.r.conf.e.entry -side left -fill x -expand 1


    if { $report(type) == "report" } {
        radiobutton .rep.f.r.conf.os.screen -text "Send to Screen" -anchor w \
	        -font $cbb(button_font) -variable report(dest) -value "screen" \
	        -relief flat -command {
	    if { "$report(file)" != "" } {
		set report(temp) $report(file)
		set report(file) ""
		update
	    }
	}
        radiobutton .rep.f.r.conf.of.file -text "Save to File or Pipe" \
		-anchor w -font $cbb(button_font) -variable report(dest) \
		-value "file" -relief flat -command {
	    if { "$report(file)" == "" } {
		if { "$report(temp)" != "" } {
		    set report(file) $report(temp)
		    update
		}
	    }
	} 
        label .rep.f.r.conf.oe.label -text "File Name"
        entry .rep.f.r.conf.oe.file -textvariable report(file) -relief sunken

        pack .rep.f.r.conf.os.screen -side left -fill x -expand 1
        pack .rep.f.r.conf.of.file -side left -fill x -expand 1
        pack .rep.f.r.conf.oe.label -side left
        pack .rep.f.r.conf.oe.file -side left -fill x -expand 1

    }

    button .rep.f.r.but.gen -text "Generate $name ..." -font $cbb(button_font) \
	    -command { reportGenerate }
    button .rep.f.r.but.dismiss -text "Dismiss" -font $cbb(button_font) \
    	    -command { 
	if { "$report(tmp_file)" != "" } { exec rm $report(tmp_file) }
	destroy .rep
    }
    pack .rep.f.r.but.gen .rep.f.r.but.dismiss -side left \
	    -fill x -expand 1 -padx 8 -pady 8

    focus .rep.f.r.conf.s.entry
}


#------------------------------------------------------------------------------
# Call the current report with the current start/end dates
#------------------------------------------------------------------------------

proc reportGenerate {} {
    global cbb report max_files files names nice_start nice_end lib_path

    # build file list
    set i 0
    while { $i <= $max_files } {
	if { $files($i) } {
	    append file_list "$names($i) "
	}
	set i [expr $i + 1]
    }

    if { $cbb(debug) } { puts $file_list }

    if { "$report(start)" != "" } {
	set nice_start "-from $report(start)"
    } else {
	set nice_start ""
    }

    if { "$report(end)" != "" } {
	set nice_end "-to $report(end)"
    } else {
	set nice_end ""
    }

    if { $cbb(debug) } { puts "From $nice_start To $nice_end" }

    if { $report(type) == "report" } {
        if { $cbb(debug) } { 
	    puts "open |$lib_path/reports/$report(name) -date $cbb(date_fmt) \
		    $nice_start $nice_end $file_list r"
	}
	set report(handle) [open "|$lib_path/reports/$report(name) \
		-date $cbb(date_fmt) $nice_start $nice_end $file_list" r]
	if { "$report(dest)" == "screen" } {
	    cbbWindow.represult
	} elseif { "$report(dest)" == "file" } {
	    if { $cbb(safe_mode) == 0 } {
		set rep_out [open "$report(file)" w]
		while { [gets $report(handle) line] >= 0 } {
		    puts $rep_out $line
		}
		close $rep_out
		cbbWindow.ok "Report written to ``$report(file)''"
		tkwait window .ok

		close $report(handle)
	    } else {
		cbbWindow.ok "Cannot print to a file when running in 'safe' \
			mode." 
		tkwait window .ok
	    }
	}
    } else {
	if { $cbb(debug) } { 
	    puts "open |$lib_path/graphs/$report(name) $nice_start \
		    $nice_end $file_list r+"
	}
        set report(handle) [open "|$lib_path/graphs/$report(name) $nice_start \
		$nice_end $file_list" r+]
    }
}


proc cbbWindow.represult {} {
    global cbb report nice_start nice_end

    option add *font $cbb(dialog_font)

    if { [winfo exists .represult] } {
	destroy .represult
    }

    toplevel .represult

    wm title .represult "$report(name): $report(start) - $report(end)"
    wm iconname .represult "Fix Me"
    frame .represult.frame -borderwidth 2 -relief raised
    frame .represult.frame.l -borderwidth 2
    frame .represult.frame.d -borderwidth 2

    pack .represult.frame .represult.frame.l .represult.frame.d -side top \
      -fill both -expand 1

    listbox .represult.frame.l.list -width 80 -height 25 -relief sunken \
	     -font $cbb(fixed_font) \
	     -yscrollcommand ".represult.frame.l.scroll set"
    pack .represult.frame.l.list -side left -fill both -expand 1

    scrollbar .represult.frame.l.scroll \
	    -command ".represult.frame.l.list yview" -relief flat
    pack .represult.frame.l.scroll -side left -fill y -expand 1

    button .represult.frame.d.dismiss -text "Dismiss" -font $cbb(button_font) \
	-command { destroy .represult }

    while { [gets $report(handle) line] >= 0 } {
	if { "$line" == "done-graph" } {
	    break
	}
	.represult.frame.l.list insert end $line
    }
    close $report(handle)

    pack .represult.frame.d.dismiss -side top -fill x -expand 1 \
	    -padx 8 -pady 4

    bind .represult <KeyPress-Down> { .represult.frame.l.list \
	    yview scroll 1 units }
    bind .represult <Control-KeyPress-n> { .represult.frame.l.list \
	    yview scroll 1 units }
    bind .represult <KeyPress-n> { .represult.frame.l.list \
	    yview scroll 1 units }
    bind .represult <KeyPress-j> { .represult.frame.l.list \
	    yview scroll 1 units }

    bind .represult <KeyPress-Up> { .represult.frame.l.list \
	    yview scroll -1 units }
    bind .represult <Control-KeyPress-p> { .represult.frame.l.list \
	    yview scroll -1 units }
    bind .represult <KeyPress-p> { .represult.frame.l.list \
	    yview scroll -1 units }
    bind .represult <KeyPress-k> { .represult.frame.l.list \
	    yview scroll -1 units }

    bind .represult <KeyPress-Next> { .represult.frame.l.list \
	    yview scroll 1 pages }
    bind .represult <Control-KeyPress-v> { .represult.frame.l.list \
	    yview scroll 1 pages }

    bind .represult <KeyPress-Prior> { .represult.frame.l.list \
	    yview scroll -1 pages }
    bind .represult <Alt-KeyPress-v> { .represult.frame.l.list \
	    yview scroll -1 pages }

}
